/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.extensions.basic.file.util;

import com.github.leeonky.dal.runtime.PartialObject;
import com.github.leeonky.util.Suppressor;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class FileGroup<T>
implements PartialObject,
Iterable<T> {
    protected static final Map<String, Function<InputStream, Object>> fileExtensions = new HashMap<String, Function<InputStream, Object>>();
    protected final String name;

    public FileGroup(String name) {
        this.name = name;
    }

    public static void register(String fileExtension, Function<InputStream, Object> fileReader) {
        fileExtensions.put(fileExtension, fileReader);
    }

    public String buildField(Object prefix, Object postfix) {
        return this.fileName(postfix);
    }

    protected String fileName(Object fileExtension) {
        return String.format("%s.%s", this.name, fileExtension);
    }

    public Object getFile(Object extensionName) {
        T subFile = this.createSubFile(this.fileName(extensionName));
        Function<InputStream, Object> handler = fileExtensions.get(extensionName);
        if (handler != null) {
            return Suppressor.get(() -> {
                try (InputStream open = this.open(subFile);){
                    Object r = handler.apply(open);
                    return r;
                }
            });
        }
        return subFile;
    }

    protected abstract InputStream open(T var1);

    protected abstract T createSubFile(String var1);

    public Set<String> list() {
        return this.listFileNameWithOrder().map(s -> s.substring(this.name.length() + 1)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected abstract Stream<String> listFileName();

    @Override
    public Iterator<T> iterator() {
        return this.listFileNameWithOrder().map(this::createSubFile).iterator();
    }

    private Stream<String> listFileNameWithOrder() {
        return this.listFileName().sorted();
    }
}

