/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.extensions.basic.file.util;

import com.github.leeonky.dal.extensions.basic.file.util.FileGroup;
import com.github.leeonky.util.InvocationException;
import com.github.leeonky.util.Suppressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.stream.Stream;

public class IOFileFileGroup
extends FileGroup<File> {
    private final File folder;

    public IOFileFileGroup(File folder, String name) {
        super(name);
        this.folder = folder;
    }

    protected FileInputStream open(File subFile) {
        return (FileInputStream)Suppressor.get(() -> new FileInputStream(subFile));
    }

    @Override
    protected File createSubFile(String fileName) {
        File subFile = new File(this.folder, fileName);
        if (!subFile.exists()) {
            throw new InvocationException((Throwable)new FileNotFoundException(String.format("File `%s` not exist", fileName)));
        }
        return subFile;
    }

    @Override
    protected Stream<String> listFileName() {
        return Arrays.stream(this.folder.list()).filter(n -> n.startsWith(this.name + "."));
    }
}

