/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.extensions.basic.file.util;

import com.github.leeonky.dal.extensions.basic.file.util.FileDirDumper;
import com.github.leeonky.dal.extensions.basic.file.util.FileFileDumper;
import com.github.leeonky.dal.extensions.basic.file.util.IOFileFileGroup;
import com.github.leeonky.dal.extensions.basic.file.util.PathDirDumper;
import com.github.leeonky.dal.extensions.basic.file.util.PathFileDumper;
import com.github.leeonky.dal.runtime.inspector.Dumper;
import com.github.leeonky.util.InvocationException;
import com.github.leeonky.util.Suppressor;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class Util {
    public static final Dumper FILE_DIR_DUMPER = new FileDirDumper();
    public static final Dumper FILE_FILE_DUMPER = new FileFileDumper();
    public static final Dumper PATH_DIR_DUMPER = new PathDirDumper();
    public static final Dumper PATH_FILE_DUMPER = new PathFileDumper();

    public static String formatFileSize(long size) {
        if (size < 10000L) {
            return String.valueOf(size);
        }
        double sizeInUnit = (double)size / 1024.0;
        if (sizeInUnit < 1000.0) {
            return String.format("%.1fK", sizeInUnit);
        }
        if ((sizeInUnit /= 1024.0) < 1000.0) {
            return String.format("%.1fM", sizeInUnit);
        }
        if ((sizeInUnit /= 1024.0) < 1000.0) {
            return String.format("%.1fG", sizeInUnit);
        }
        return String.format("%.1fT", sizeInUnit /= 1024.0);
    }

    public static String attribute(Path path) {
        PosixFileAttributes posixFileAttributes = (PosixFileAttributes)Suppressor.get(() -> Files.readAttributes(path, PosixFileAttributes.class, new LinkOption[0]));
        return String.format("%s %s %s %6s %s %s", PosixFilePermissions.toString(posixFileAttributes.permissions()), posixFileAttributes.group(), posixFileAttributes.owner(), Util.formatFileSize(path.toFile().length()), posixFileAttributes.lastModifiedTime(), path.getFileName().toString());
    }

    public static Object getSubFile(File file, String name) {
        File subFile = new File(file, name);
        if (subFile.exists()) {
            return subFile;
        }
        String[] list = file.list();
        if (list != null && Arrays.stream(list).anyMatch(f -> f.startsWith(name + "."))) {
            return new IOFileFileGroup(file, name);
        }
        throw new InvocationException((Throwable)new FileNotFoundException(String.format("File or File Group <%s> not found", name)));
    }

    public static Set<Object> listFileNames(File file) {
        return Util.listFile(file).stream().map(File::getName).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<File> listFile(File file) {
        File[] files = file.listFiles();
        return files == null ? Collections.emptySet() : (Set)Arrays.stream(files).sorted(Comparator.comparing(File::isDirectory).thenComparing(File::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<Path> listFile(Path path) {
        File[] files = path.toFile().listFiles();
        return files == null ? Collections.emptySet() : (Set)Arrays.stream(files).sorted(Comparator.comparing(File::isDirectory).thenComparing(File::getName)).map(File::toPath).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

