/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.extensions.basic.list;

import com.github.leeonky.dal.DAL;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.extensions.basic.list.NotReadyException;
import com.github.leeonky.dal.runtime.DALCollection;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ExpressionException;
import com.github.leeonky.dal.runtime.Extension;
import com.github.leeonky.dal.runtime.Operation;
import com.github.leeonky.dal.runtime.Operators;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;

public class ListExtension
implements Extension {
    public void extend(DAL dal) {
        dal.getRuntimeContextBuilder().registerMetaProperty((Object)"top", metaData -> arg_0 -> ((Data.DataList)((Data.DataList)ExpressionException.opt2(() -> ((Data)metaData.data()).list()))).limit(arg_0)).registerMetaProperty((Object)"filter", metaData -> new Filterable(metaData.data())).registerOperator(Operators.MATCH, (Operation)new VerificationInFilter()).registerOperator(Operators.EQUAL, (Operation)new VerificationInFilter()).registerExclamation(Filterable.class, runtimeData -> runtimeData.data().map(instance -> ((Filterable)instance).requireNotEmpty())).registerDataRemark(Filterable.class, remarkData -> remarkData.data().map(instance -> ((Filterable)instance).require(Integer.parseInt(remarkData.remark()))));
    }

    private static class VerificationInFilter
    implements Operation {
        private VerificationInFilter() {
        }

        public boolean match(Data v1, DALOperator operator, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
            return v1.instance() instanceof Filterable;
        }

        public Data operate(Data v1, DALOperator operator, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
            return ((Filterable)v1.instance()).filter(operator, v2, context);
        }
    }

    public static class Filterable {
        private final Data data;

        public Filterable(Data data) {
            this.data = data;
        }

        public Data filter(DALOperator operator, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
            return this.data.map(ignore -> this.filterList(operator, v2, context));
        }

        protected DALCollection<Object> filterList(DALOperator operator, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
            return ((Data.DataList)ExpressionException.opt1(() -> ((Data)this.data).list())).wraps().filter(element -> {
                try {
                    context.calculate(element, operator, v2);
                    return true;
                }
                catch (Exception ig) {
                    return false;
                }
            }).map((i, d) -> d.instance());
        }

        public Filterable requireNotEmpty() {
            return new Filterable(this.data){

                @Override
                protected DALCollection<Object> filterList(DALOperator operator, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
                    DALCollection<Object> list = super.filterList(operator, v2, context);
                    if (!list.iterator().hasNext()) {
                        throw ExpressionException.exception(expression -> new NotReadyException("Filtered result is empty, try again", expression.left().getOperandPosition()));
                    }
                    return list;
                }
            };
        }

        public Filterable require(final int size) {
            return new Filterable(this.data){

                @Override
                protected DALCollection<Object> filterList(DALOperator operator, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
                    DALCollection list = super.filterList(operator, v2, context).limit(size);
                    if (list.size() >= size) {
                        return list;
                    }
                    throw ExpressionException.exception(expression -> new NotReadyException(String.format("There are only %d elements, try again", list.size()), expression.left().getOperandPosition()));
                }
            };
        }
    }
}

