/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.extensions.basic.sftp.util;

import com.github.leeonky.dal.extensions.basic.file.util.Util;
import com.github.leeonky.dal.extensions.basic.sftp.util.SFtpFile;
import com.github.leeonky.util.Suppressor;
import com.github.leeonky.util.function.Extension;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;

public class SFtp
extends SFtpFile {
    private final String host;
    private final String port;
    private final String user;
    private final String password;
    private final String path;
    private final ChannelSftp channel;

    public SFtp(String host, String port, String user, String password, String path) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.path = path;
        this.channel = (ChannelSftp)Suppressor.get(this::getChannelSftp);
    }

    private ChannelSftp getChannelSftp() throws JSchException {
        JSch jsch = new JSch();
        Session jschSession = jsch.getSession(this.user, this.host, Integer.parseInt(this.port));
        jschSession.setConfig("StrictHostKeyChecking", "no");
        jschSession.setPassword(this.password);
        jschSession.connect();
        ChannelSftp channel = (ChannelSftp)jschSession.openChannel("sftp");
        channel.connect();
        return channel;
    }

    @Override
    public String name() {
        return Paths.get(this.path, new String[0]).getFileName().toString();
    }

    @Override
    protected ChannelSftp channel() {
        return this.channel;
    }

    @Override
    protected String fullName() {
        return this.path;
    }

    @Override
    public boolean isDir() {
        return ((SftpATTRS)Suppressor.get(() -> this.channel.lstat(this.path))).isDir();
    }

    @Override
    public String attribute() {
        String name = Paths.get(this.path, new String[0]).getFileName().toString();
        return SFtp.attribute(((Vector)Suppressor.get(() -> this.channel.ls(Paths.get(this.path, new String[0]).getParent().toString()))).stream().filter(e -> e.getFilename().equals(name)).findFirst().orElseThrow(IllegalStateException::new));
    }

    @Override
    public String remote() {
        return this.user + "@" + this.host;
    }

    private static String attribute(ChannelSftp.LsEntry entry) {
        SftpATTRS attrs = entry.getAttrs();
        List items = Arrays.stream(entry.getLongname().split(" ")).filter(Extension.not(String::isEmpty)).collect(Collectors.toList());
        return String.format("%s %s %s %6s %s", attrs.getPermissionsString(), items.get(2), items.get(3), Util.formatFileSize(attrs.getSize()), Instant.ofEpochMilli((long)attrs.getMTime() * 1000L));
    }

    public void close() {
        this.channel.exit();
        Suppressor.run(() -> this.channel.getSession().disconnect());
    }

    public static class SubSFtpFile
    extends SFtpFile {
        private final SFtpFile parent;
        private final ChannelSftp.LsEntry entry;
        private final ChannelSftp channel;
        private final String remote;

        public SubSFtpFile(SFtpFile parent, ChannelSftp.LsEntry entry, ChannelSftp channel, String remote) {
            this.parent = parent;
            this.entry = entry;
            this.channel = channel;
            this.remote = remote;
        }

        public String toString() {
            return this.name();
        }

        @Override
        public String name() {
            return this.entry.getFilename();
        }

        @Override
        protected ChannelSftp channel() {
            return this.channel;
        }

        @Override
        protected String fullName() {
            return this.parent.fullName() + "/" + this.name();
        }

        @Override
        public boolean isDir() {
            return this.entry.getAttrs().isDir();
        }

        @Override
        public String attribute() {
            return SFtp.attribute(this.entry);
        }

        @Override
        public String remote() {
            return this.remote;
        }
    }
}

