/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.extensions.basic.sync;

import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.extensions.basic.TimeUtil;
import com.github.leeonky.dal.extensions.basic.list.NotReadyException;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.DataRemarkParameterAcceptor;
import com.github.leeonky.dal.runtime.ExpectationFactory;
import com.github.leeonky.util.Suppressor;
import java.util.function.Function;

public class Await {
    private static int defaultWaitingTime = 5000;
    private final Data data;
    private final int interval;
    private final int waitingTime;

    public Await(Data data) {
        this(data, 100, defaultWaitingTime);
    }

    public Await(Data data, int interval, int waitingTime) {
        this.data = data;
        this.interval = interval;
        this.waitingTime = waitingTime;
    }

    public static void setDefaultWaitingTime(int ms) {
        defaultWaitingTime = ms;
    }

    public Data await(DALOperator operator, Data v2, Function<ExpectationFactory.Expectation, Data> action) {
        int times = this.waitingTime / this.interval;
        while (true) {
            --times;
            try {
                return action.apply(((ExpectationFactory)v2.instance()).create(operator, this.data));
            }
            catch (NotReadyException e) {
                NotReadyException exception = e;
                if (times <= 0) continue;
                Suppressor.run(() -> Thread.sleep(this.interval));
                if (times > 0) continue;
                throw exception;
            }
            break;
        }
    }

    public Await within(String s) {
        return new Await(this.data, this.interval, TimeUtil.parseTime(s));
    }

    public DataRemarkParameterAcceptor<Await> interval() {
        return s -> new Await(this.data, TimeUtil.parseTime(s), this.waitingTime);
    }
}

