/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.extensions.basic.sync;

import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.extensions.basic.TimeUtil;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.DataRemarkParameterAcceptor;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.util.Suppressor;

public class Eventually {
    private static int defaultWaitingTime = 5000;
    private final Data data;
    private final int interval;
    private final int waitingTime;

    public Eventually(Data data) {
        this(data, 100, defaultWaitingTime);
    }

    public Eventually(Data data, int interval, int waitingTime) {
        this.data = data;
        this.interval = interval;
        this.waitingTime = waitingTime;
    }

    public static void setDefaultWaitingTime(int defaultWaitingTime) {
        Eventually.defaultWaitingTime = defaultWaitingTime;
    }

    public Data verify(DALOperator operator, Data v2, RuntimeContextBuilder.DALRuntimeContext context) {
        int times = this.waitingTime / this.interval;
        while (true) {
            --times;
            try {
                return context.calculate(this.data, operator, v2);
            }
            catch (RuntimeException e) {
                RuntimeException exception = e;
                if (times <= 0) continue;
                Suppressor.run(() -> Thread.sleep(this.interval));
                if (times > 0) continue;
                throw exception;
            }
            break;
        }
    }

    public DataRemarkParameterAcceptor<Eventually> within() {
        return s -> new Eventually(this.data, this.interval, TimeUtil.parseTime(s));
    }

    public DataRemarkParameterAcceptor<Eventually> interval() {
        return s -> new Eventually(this.data, TimeUtil.parseTime(s), this.waitingTime);
    }
}

