/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.extensions.basic.text;

import com.github.leeonky.dal.DAL;
import com.github.leeonky.dal.extensions.basic.binary.BinaryExtension;
import com.github.leeonky.dal.extensions.basic.file.util.FileGroup;
import com.github.leeonky.dal.extensions.basic.text.Methods;
import com.github.leeonky.dal.runtime.Extension;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.TextAttribute;
import com.github.leeonky.dal.runtime.TextFormatter;

public class TextExtension
implements Extension {
    public void extend(DAL dal) {
        RuntimeContextBuilder builder = dal.getRuntimeContextBuilder();
        builder.registerStaticMethodExtension(Methods.class);
        builder.registerTextFormatter("JSON", this.jsonTextFormatter("JSON"));
        builder.registerTextFormatter("json", this.jsonTextFormatter("json"));
        FileGroup.register("json", inputStream -> Methods.json(BinaryExtension.readAll(inputStream)));
        FileGroup.register("JSON", inputStream -> Methods.json(BinaryExtension.readAll(inputStream)));
        builder.registerTextFormatter("YAML", this.yamlTextFormatter("YAML"));
        builder.registerTextFormatter("yaml", this.yamlTextFormatter("yaml"));
        FileGroup.register("yaml", inputStream -> Methods.yaml(BinaryExtension.readAll(inputStream)));
        FileGroup.register("YAML", inputStream -> Methods.yaml(BinaryExtension.readAll(inputStream)));
    }

    private TextFormatter<String, Object> jsonTextFormatter(final String label) {
        return new TextFormatter<String, Object>(){

            protected Object format(String content, TextAttribute attribute, RuntimeContextBuilder.DALRuntimeContext context) {
                return Methods.json(content);
            }

            public String description() {
                return "use " + label + " as json object";
            }
        };
    }

    private TextFormatter<String, Object> yamlTextFormatter(final String label) {
        return new TextFormatter<String, Object>(){

            protected Object format(String content, TextAttribute attribute, RuntimeContextBuilder.DALRuntimeContext context) {
                return Methods.yaml(content);
            }

            public String description() {
                return "use " + label + " to as yaml object";
            }
        };
    }
}

