/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.extensions.basic.zip.util;

import com.github.leeonky.dal.extensions.basic.binary.BinaryExtension;
import com.github.leeonky.dal.extensions.basic.zip.util.ZipNodeCollection;
import com.github.leeonky.util.Suppressor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipBinary
extends ZipNodeCollection {
    public ZipBinary(byte[] data) {
        Suppressor.run(() -> this.unzipToMemory(data).forEach((? super K entry, ? super V bytes) -> this.addNode(Arrays.stream(entry.getName().split("/")).filter(s -> !s.isEmpty()).collect(Collectors.toCollection(LinkedList::new)), (ZipEntry)entry, (byte[])bytes)));
    }

    private TreeMap<ZipEntry, byte[]> unzipToMemory(byte[] data) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(data));){
            TreeMap<ZipEntry, byte[]> treeMap = new TreeMap<ZipEntry, byte[]>(Comparator.comparing(ZipEntry::getName));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                treeMap.put(zipEntry, BinaryExtension.readAll(zipInputStream));
                zipEntry = zipInputStream.getNextEntry();
            }
            TreeMap<ZipEntry, byte[]> treeMap2 = treeMap;
            return treeMap2;
        }
    }

    public static class ZipNode
    extends ZipNodeCollection {
        private final ZipEntry entry;
        private final String name;
        private final boolean directory;
        private final byte[] bytes;

        public ZipNode(ZipEntry entry, String name, byte[] bytes) {
            this.entry = entry;
            this.name = name;
            this.directory = entry.isDirectory();
            this.bytes = bytes;
        }

        public String toString() {
            return this.name;
        }

        public String name() {
            return this.name;
        }

        public InputStream open() {
            return new ByteArrayInputStream(this.bytes);
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public long getSize() {
            return this.entry.getSize();
        }

        public Instant lastModifiedTime() {
            return this.entry.getLastModifiedTime().toInstant();
        }
    }
}

