/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.extensions.basic.zip.util;

import com.github.leeonky.dal.extensions.basic.zip.util.ZipBinary;
import com.github.leeonky.dal.extensions.basic.zip.util.ZipFileFileGroup;
import com.github.leeonky.util.InvocationException;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;

public abstract class ZipNodeCollection
implements Iterable<ZipBinary.ZipNode> {
    protected final Map<String, ZipBinary.ZipNode> children = new LinkedHashMap<String, ZipBinary.ZipNode>();

    public Set<String> list() {
        return this.children.keySet();
    }

    @Override
    public Iterator<ZipBinary.ZipNode> iterator() {
        return this.children.values().iterator();
    }

    public ZipBinary.ZipNode createSub(String fileName) {
        ZipBinary.ZipNode zipNode = this.children.get(fileName);
        if (zipNode == null) {
            throw new InvocationException((Throwable)new FileNotFoundException(String.format("File `%s` not exist", fileName)));
        }
        return zipNode;
    }

    public Object getSub(String name) {
        ZipBinary.ZipNode zipNode = this.children.get(name);
        if (zipNode != null) {
            return zipNode;
        }
        if (this.list().stream().anyMatch(f -> f.startsWith(name + "."))) {
            return new ZipFileFileGroup(this, name);
        }
        throw new InvocationException((Throwable)new FileNotFoundException(String.format("File or File Group <%s> not found", name)));
    }

    public void addNode(LinkedList<String> path, ZipEntry zipEntry, byte[] bytes) {
        String name = path.pop();
        if (path.size() == 0) {
            this.children.put(name, new ZipBinary.ZipNode(zipEntry, name, bytes));
        } else {
            this.children.get(name).addNode(path, zipEntry, bytes);
        }
    }
}

