/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.extensions.basic.zip.util;

import com.github.leeonky.dal.extensions.basic.binary.BinaryExtension;
import com.github.leeonky.dal.extensions.basic.zip.util.ZipBinary;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.inspector.Dumper;
import com.github.leeonky.dal.runtime.inspector.DumpingBuffer;

public class ZipNodeDumper
implements Dumper {
    public void dump(Data data, DumpingBuffer context) {
        ZipBinary.ZipNode node = (ZipBinary.ZipNode)data.instance();
        if (node.isDirectory()) {
            DumpingBuffer sub = context.append(node.name()).append("/").indent();
            data.list().wraps().values().forEach(subFile -> sub.newLine().dumpValue(subFile));
        } else if (node.name().toLowerCase().endsWith(".zip")) {
            context.append(node.name()).indent().dumpValue(context.getRuntimeContext().wrap((Object)new ZipBinary(BinaryExtension.readAll(node.open()))));
        } else {
            context.append(String.format("%s %6s %s", node.lastModifiedTime(), node.getSize(), node.name()));
        }
    }
}

