/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.jsonassert;

import com.github.leeonky.dal.AssertResult;
import com.github.leeonky.dal.DalException;
import com.github.leeonky.dal.DataAssert;
import com.github.leeonky.dal.util.ListAccessor;
import com.github.leeonky.dal.util.PropertyAccessor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.comparator.DefaultComparator;

public class PatternComparator
extends DefaultComparator {
    public static final String PREFIX = "**";
    private final String prefix;
    private DataAssert dataAssert = new DataAssert();

    private PatternComparator(String prefix) {
        super(JSONCompareMode.STRICT);
        this.prefix = prefix;
        this.dataAssert.getRuntimeContextBuilder().registerPropertyAccessor(JSONObject.class, (PropertyAccessor)new PropertyAccessor<JSONObject>(){

            public Object getValue(JSONObject instance, String name) {
                try {
                    return instance.has(name) ? instance.get(name) : JSONObject.NULL;
                }
                catch (JSONException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            public Set<String> getPropertyNames(JSONObject instance) {
                HashSet<String> set = new HashSet<String>();
                Iterator iterator = instance.keys();
                while (iterator.hasNext()) {
                    set.add(iterator.next().toString());
                }
                return set;
            }

            public boolean isNull(JSONObject instance) {
                return instance == null || instance.equals(JSONObject.NULL);
            }
        });
        this.dataAssert.getRuntimeContextBuilder().registerListAccessor(JSONArray.class, (ListAccessor)new ListAccessor<JSONArray>(){

            public Object get(JSONArray jsonArray, int index) {
                try {
                    return jsonArray.get(index);
                }
                catch (JSONException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            public int size(JSONArray jsonArray) {
                return jsonArray.length();
            }
        });
    }

    public static PatternComparator defaultPatternComparator() {
        return new PatternComparator(PREFIX);
    }

    public DataAssert getDataAssert() {
        return this.dataAssert;
    }

    public void compareValues(String prefix, Object expectedValue, Object actualValue, JSONCompareResult result) throws JSONException {
        String sourceCode;
        String trim;
        if (expectedValue instanceof String && (trim = (sourceCode = (String)expectedValue).trim()).startsWith(this.prefix)) {
            try {
                AssertResult assertResult = this.dataAssert.assertData(actualValue, trim.substring(this.prefix.length()));
                if (!assertResult.isPassed()) {
                    result.fail(prefix, expectedValue, (Object)String.valueOf(actualValue));
                }
                return;
            }
            catch (DalException e) {
                throw new RuntimeException(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage() + "\n" + expectedValue + "\n" + String.join((CharSequence)"", Collections.nCopies(e.getPosition() + this.prefix.length(), " ")) + "^");
            }
        }
        super.compareValues(prefix, expectedValue, actualValue, result);
    }
}

