/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.jsonassert;

import com.github.leeonky.dal.AssertResult;
import com.github.leeonky.dal.DalException;
import com.github.leeonky.dal.DataAssert;
import com.github.leeonky.dal.util.ListAccessor;
import com.github.leeonky.dal.util.PropertyAccessor;
import com.github.leeonky.jsonassert.checker.Checker;
import com.github.leeonky.jsonassert.checker.NaturalNumberChecker;
import com.github.leeonky.jsonassert.checker.ObjectChecker;
import com.github.leeonky.jsonassert.checker.PatternChecker;
import com.github.leeonky.jsonassert.checker.URLChecker;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.comparator.DefaultComparator;

public class PatternComparator
extends DefaultComparator {
    public static final String PREFIX = "**";
    private final String prefix;
    private DataAssert dataAssert = new DataAssert();
    private Map<String, Checker> checkers = new HashMap<String, Checker>();

    private PatternComparator(String prefix) {
        super(JSONCompareMode.STRICT);
        this.prefix = prefix;
        this.checkers.put(prefix + "ANY_URL", new URLChecker());
        this.checkers.put(prefix + "ANY_NATURAL_NUMBER", new NaturalNumberChecker());
        this.checkers.put(prefix + "ANY_OBJECT", new ObjectChecker());
        this.checkers.put(prefix + "ANY_UTC", new PatternChecker("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.?\\d*Z", String.class));
        this.dataAssert.getRuntimeContextBuilder().registerPropertyAccessor(JSONObject.class, (PropertyAccessor)new PropertyAccessor<JSONObject>(){

            public Object getValue(JSONObject instance, String name) {
                try {
                    return instance.get(name);
                }
                catch (JSONException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            public Set<String> getPropertyNames(JSONObject instance) {
                HashSet<String> set = new HashSet<String>();
                Iterator iterator = instance.keys();
                while (iterator.hasNext()) {
                    set.add(iterator.next().toString());
                }
                return set;
            }
        });
        this.dataAssert.getRuntimeContextBuilder().registerListAccessor(JSONArray.class, (ListAccessor)new ListAccessor<JSONArray>(){

            public Object get(JSONArray jsonArray, int index) {
                try {
                    return jsonArray.get(index);
                }
                catch (JSONException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            public int size(JSONArray jsonArray) {
                return jsonArray.length();
            }
        });
    }

    public static PatternComparator defaultPatternComparator() {
        return new PatternComparator(PREFIX);
    }

    public DataAssert getDataAssert() {
        return this.dataAssert;
    }

    public void compareValues(String prefix, Object expectedValue, Object actualValue, JSONCompareResult result) throws JSONException {
        if (expectedValue instanceof String) {
            String sourceCode = (String)expectedValue;
            Checker checker = this.checkers.get(sourceCode.split(" ")[0]);
            if (checker != null) {
                checker.verify(prefix, expectedValue, actualValue, result);
                return;
            }
            String trim = sourceCode.trim();
            if (trim.startsWith(this.prefix)) {
                try {
                    AssertResult assertResult = this.dataAssert.assertData(actualValue, trim.substring(this.prefix.length()));
                    if (!assertResult.isPassed()) {
                        result.fail(prefix, expectedValue, (Object)String.valueOf(actualValue));
                    }
                    return;
                }
                catch (DalException e) {
                    throw new RuntimeException(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage() + "\n" + expectedValue + "\n" + String.join((CharSequence)"", Collections.nCopies(e.getPosition() + this.prefix.length(), " ")) + "^");
                }
            }
        }
        super.compareValues(prefix, expectedValue, actualValue, result);
    }
}

