/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.jsonassert.checker;

import com.github.leeonky.jsonassert.checker.Checker;
import com.github.leeonky.jsonassert.checker.VerbChecker;
import com.github.leeonky.jsonassert.checker.verb.VerbContain;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.skyscreamer.jsonassert.JSONCompareResult;

public abstract class AbstractChecker
implements Checker {
    private final List<Class<?>> acceptTypes;
    protected Set<String> allowVerbs = new HashSet<String>();

    protected AbstractChecker(Class<?> ... acceptTypes) {
        this.acceptTypes = Arrays.asList(acceptTypes);
    }

    @Override
    public void verify(String prefix, Object expectedValue, Object actualValue, JSONCompareResult result) {
        if (this.isValidType(actualValue)) {
            VerbChecker verbChecker = this.buildVerbChecker(expectedValue, result);
            if (verbChecker == null || !this.isValueMatched(actualValue) || !verbChecker.isValueMatched(prefix, actualValue, result)) {
                result.fail(prefix, expectedValue, actualValue);
            }
        } else {
            result.fail("Type miss matched, expect " + this.acceptTypes.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")) + " but " + actualValue.getClass().getSimpleName());
        }
    }

    protected boolean isValueMatched(Object actualValue) {
        return true;
    }

    private boolean isValidType(Object actualValue) {
        return this.acceptTypes.stream().anyMatch(c -> c.isInstance(actualValue));
    }

    protected VerbChecker buildVerbChecker(Object expectedValue, JSONCompareResult result) {
        String[] strings = expectedValue.toString().split(" ", 3);
        if (strings.length > 1) {
            String verb = strings[1];
            if (this.allowVerbs.contains(verb)) {
                return this.createVerbChecker(verb, strings.length > 2 ? strings[2] : "");
            }
            result.fail("Verb " + verb + " not allowed for " + strings[0]);
            return null;
        }
        return (x, y, z) -> true;
    }

    protected VerbContain createVerbChecker(String verb, String args) {
        switch (verb) {
            case "CONTAINS": {
                return new VerbContain(args);
            }
        }
        throw new IllegalArgumentException("Unsupport verb " + verb);
    }
}

