/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.util;

import com.github.leeonky.util.JavaSourceFromString;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class JavaCompiler {
    private final URLClassLoader loader = this.getUrlClassLoader();
    private final String packageName;
    private final int id;

    public JavaCompiler(String packageName, int id) {
        this.packageName = packageName + id;
        this.id = id;
    }

    private URLClassLoader getUrlClassLoader() {
        return URLClassLoader.newInstance(new URL[]{new File("").toURI().toURL()});
    }

    public static String guessClassName(String code) {
        String s = Stream.of(code.split("\n")).filter(l -> l.contains("class") || l.contains("interface")).findFirst().orElse(null);
        Matcher matcher = Pattern.compile(".* class\\s(.*)\\sextends.*", 32).matcher(s);
        if (matcher.matches()) {
            return matcher.group(1).trim();
        }
        matcher = Pattern.compile(".* class\\s(.*)\\simplements.*", 32).matcher(s);
        if (matcher.matches()) {
            return matcher.group(1).trim();
        }
        matcher = Pattern.compile(".* class\\s([^{]*)\\s\\{.*", 32).matcher(s);
        if (matcher.matches()) {
            return matcher.group(1).trim();
        }
        matcher = Pattern.compile(".* interface\\s(.*)\\sextends.*", 32).matcher(s);
        if (matcher.matches()) {
            return matcher.group(1).trim();
        }
        matcher = Pattern.compile(".* interface\\s([^{]*)\\s\\{.*", 32).matcher(s);
        if (matcher.matches()) {
            return matcher.group(1).trim();
        }
        throw new IllegalStateException("Can not guess class name of code:\n" + code);
    }

    public List<Class<?>> compileToClasses(List<String> classCodes) {
        if (classCodes.isEmpty()) {
            return Collections.emptyList();
        }
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        List files = classCodes.stream().map(code -> new JavaSourceFromString(JavaCompiler.guessClassName(code).replaceAll("<.*>", ""), this.declarePackage() + code)).collect(Collectors.toList());
        javax.tools.JavaCompiler systemJavaCompiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager standardFileManager = systemJavaCompiler.getStandardFileManager(diagnostics, null, null);
        standardFileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singletonList(new File("./")));
        if (!systemJavaCompiler.getTask(null, standardFileManager, diagnostics, null, null, files).call().booleanValue()) {
            System.out.println(diagnostics.getDiagnostics().stream().filter(d -> d.getSource() != null).collect(Collectors.groupingBy(Diagnostic::getSource)).entrySet().stream().map(this::compileResults).collect(Collectors.joining("\n")));
            throw new IllegalStateException("Failed to compile java code: \n");
        }
        return files.stream().map(f -> f.name).map(this::loadClass).collect(Collectors.toList());
    }

    private String declarePackage() {
        return this.packageName.isEmpty() ? "" : "package " + this.packageName + ";";
    }

    private String compileResults(Map.Entry<? extends JavaFileObject, List<Diagnostic<? extends JavaFileObject>>> e) {
        String sourceCode = String.valueOf(e.getKey().getCharContent(true));
        Object[] codeBase = sourceCode.chars().mapToObj(c -> Character.valueOf((char)(c == 10 ? (int)c : 32))).map(String::valueOf).toArray();
        ArrayList<String> result = new ArrayList<String>();
        result.add(e.getKey().toString());
        for (Diagnostic<? extends JavaFileObject> diagnostic : e.getValue()) {
            result.add(diagnostic.getMessage(null));
            if (diagnostic.getPosition() < 0L || diagnostic.getPosition() >= (long)codeBase.length) continue;
            codeBase[(int)diagnostic.getPosition()] = Character.valueOf('^');
        }
        String[] codes = sourceCode.split("\n");
        String[] codeMarks = Stream.of(codeBase).map(String::valueOf).collect(Collectors.joining()).split("\n");
        for (int i = 0; i < codes.length; ++i) {
            result.add(codes[i]);
            if (i >= codeMarks.length || codeMarks[i].trim().isEmpty()) continue;
            result.add(codeMarks[i]);
        }
        return String.join((CharSequence)"\n", result);
    }

    private Class<?> loadClass(String name) {
        return Class.forName(this.packagePrefix() + name, true, this.loader);
    }

    public String packagePrefix() {
        return this.packageName.isEmpty() ? "" : this.packageName + ".";
    }

    public int getId() {
        return this.id;
    }
}

