/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.util;

import com.github.leeonky.util.JavaCompiler;
import com.github.leeonky.util.Suppressor;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class JavaCompilerPool {
    private final BlockingDeque<Integer> workspaces;
    private final String generatePackage;

    public JavaCompilerPool(int maxCount, String generatePackage) {
        this.workspaces = IntStream.range(0, maxCount).boxed().collect(Collectors.toCollection(LinkedBlockingDeque::new));
        this.generatePackage = generatePackage;
    }

    public JavaCompiler take() {
        return new JavaCompiler(this.generatePackage, (Integer)Suppressor.get(this.workspaces::takeFirst));
    }

    public void giveBack(JavaCompiler compiler) {
        Suppressor.run(() -> this.workspaces.putLast(compiler.getId()));
    }
}

