/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.map;

import com.github.leeonky.map.ElementProperty;
import com.github.leeonky.map.FromProperty;
import com.github.leeonky.map.ListConverter;
import com.github.leeonky.map.MapConverter;
import com.github.leeonky.map.Mapper;
import com.github.leeonky.map.ViewListConverter;
import com.github.leeonky.map.ViewMapConverter;

class FromPropertyWrapper {
    final ElementProperty key;
    final ElementProperty value;

    FromPropertyWrapper(FromProperty fromProperty) {
        this.value = new ElementProperty(fromProperty.value());
        this.key = fromProperty.key().isEmpty() ? null : new ElementProperty(fromProperty.key());
    }

    boolean isFlatToCollection() {
        return this.value.elementName != null && (this.key == null || this.key.elementName == null);
    }

    boolean isFlatToMap() {
        return this.value.elementName != null && this.key != null && this.key.elementName != null;
    }

    boolean isDifferentSourceProperty() {
        return !this.value.name.equals(this.key.name);
    }

    ViewMapConverter createViewMapConverter(Mapper mapper, Class<?> view) {
        return new ViewMapConverter(mapper, view, this.key.elementName, this.value.elementName);
    }

    ViewListConverter createViewListConverter(Mapper mapper, Class<?> view) {
        return new ViewListConverter(mapper, view, this.value.elementName);
    }

    ListConverter createListPropertyConverter(Mapper mapper, String desName) {
        return new ListConverter(mapper, this.value.elementName, desName);
    }

    MapConverter createMapPropertyConverter(Mapper mapper, String desName) {
        return new MapConverter(mapper, this.key.elementName, this.value.elementName, desName);
    }
}

