/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.map;

import com.github.leeonky.map.BaseConverter;
import com.github.leeonky.map.Mapper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.metadata.Type;

class ListConverter
extends BaseConverter {
    private final Mapper mapper;
    private final String elementName;
    private final String desName;

    ListConverter(Mapper mapper, String elementName, String desName) {
        this.mapper = mapper;
        this.elementName = elementName;
        this.desName = desName;
    }

    @Override
    public String buildConvertId() {
        return String.format("ListConverter:%s-%s[%d]", this.elementName, this.desName, this.mapper.hashCode());
    }

    public Object convert(Object source, Type<?> destinationType, MappingContext mappingContext) {
        Iterable collection;
        Class rawType = destinationType.getRawType();
        Iterable iterable = collection = source instanceof Map ? ListConverter.wrapperEntry((Map)source) : (Iterable)source;
        if (Iterable.class.isAssignableFrom(rawType)) {
            return this.mapCollection(collection, ListConverter.createCollection(rawType), ((Type)destinationType.getActualTypeArguments()[0]).getRawType());
        }
        if (rawType.isArray()) {
            return this.mapCollection(collection, new ArrayList(), rawType.getComponentType()).toArray((Object[])Array.newInstance(rawType.getComponentType(), 0));
        }
        throw new IllegalStateException(String.format("Type of '%s.%s' is invalid, expect Iterable or Array", mappingContext.getResolvedDestinationType().getName(), this.desName));
    }

    private Collection<Object> mapCollection(Iterable source, Collection result, Class elementType) {
        for (Object object : source) {
            result.add(this.mapper.mapTo(ListConverter.getPropertyValue(object, this.elementName), elementType));
        }
        return result;
    }
}

