/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.map;

import com.github.leeonky.map.BaseConverter;
import com.github.leeonky.map.Mapper;
import java.util.Map;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.metadata.Type;

class MapConverter
extends BaseConverter {
    private final Mapper mapper;
    private final String keyPropertyName;
    private final String propertyName;
    private final String desName;

    MapConverter(Mapper mapper, String keyPropertyName, String propertyName, String desName) {
        this.mapper = mapper;
        this.keyPropertyName = keyPropertyName;
        this.propertyName = propertyName;
        this.desName = desName;
    }

    @Override
    public String buildConvertId() {
        return String.format("MapConverter:%s:%s-%s[%d]", this.keyPropertyName, this.propertyName, this.desName, this.mapper.hashCode());
    }

    public Object convert(Object source, Type<?> destinationType, MappingContext mappingContext) {
        Class rawType = destinationType.getRawType();
        Iterable collection = source instanceof Map ? MapConverter.wrapperEntry((Map)source) : (Iterable)source;
        return this.mapMap(collection, MapConverter.createMap(rawType), ((Type)destinationType.getActualTypeArguments()[1]).getRawType());
    }

    private Map mapMap(Iterable source, Map result, Class elementType) {
        source.forEach(e -> result.put(MapConverter.getPropertyValue(e, this.keyPropertyName), this.mapper.mapTo(MapConverter.getPropertyValue(e, this.propertyName), elementType)));
        return result;
    }
}

