/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.map;

import com.github.leeonky.map.BaseConverter;
import com.github.leeonky.map.Mapping;
import com.github.leeonky.map.MappingFrom;
import com.github.leeonky.map.MappingRegisterData;
import com.github.leeonky.map.MappingScope;
import com.github.leeonky.map.MappingView;
import com.github.leeonky.map.PropertyNonDefaultMapping;
import com.github.leeonky.util.BeanClass;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ma.glasnost.orika.Converter;
import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.impl.DefaultMapperFactory;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.TypeFactory;
import org.reflections.Reflections;

public class Mapper {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Class<?>[] VOID_SCOPES = new Class[]{Void.TYPE};
    private final Class[] annotations = new Class[]{Mapping.class, MappingFrom.class, MappingView.class, MappingScope.class};
    private final MapperFactory mapperFactory = new DefaultMapperFactory.Builder().build();
    private final MappingRegisterData mappingRegisterData = new MappingRegisterData();
    private Class<?> scope = Void.TYPE;

    public Mapper(String ... packages) {
        this.collectAllClasses(packages).forEach(this::register);
    }

    static <T> T NotSupportParallelStreamReduce(T u1, T u2) {
        throw new IllegalStateException("Not support parallel stream");
    }

    static Class<?>[] guessValueInSequence(Class<?> mapTo, Class<?>[] defaultReturn, Function<Class<?>, Class<?>[]> ... functions) {
        return Stream.of(functions).map(f -> (Class[])f.apply(mapTo)).filter(froms -> ((Class[])froms).length != 0).findFirst().orElse(defaultReturn);
    }

    public MapperFactory rawMapper() {
        return this.mapperFactory;
    }

    private void register(Class<?> mapTo) {
        for (Class<?> view : this.getViews(mapTo)) {
            for (Class<?> from : this.getFroms(mapTo)) {
                for (Class<?> scope : this.getScopes(mapTo, VOID_SCOPES)) {
                    this.mappingRegisterData.register(from, view, scope, mapTo);
                }
                this.configNonDefaultMapping(from, mapTo);
            }
        }
        for (Class<?> nested : mapTo.getDeclaredClasses()) {
            this.register(nested);
        }
    }

    private Set<Class<?>> collectAllClasses(Object[] packages) {
        Reflections reflections = new Reflections(packages);
        Set classes = reflections.getTypesAnnotatedWith(Mapping.class);
        classes.addAll(reflections.getTypesAnnotatedWith(MappingFrom.class));
        return classes;
    }

    private Class<?>[] getScopes(Class<?> mapTo, Class<?>[] defaultReturn) {
        return Mapper.guessValueInSequence(mapTo, defaultReturn, this::getScopeFromMappingFrom, this::getScopeFromMapping, this::getScopeFromDeclaring, this::getScopeFromSuper);
    }

    private Class<?>[] getScopeFromMapping(Class<?> mapTo) {
        Mapping declaredMapping = mapTo.getDeclaredAnnotation(Mapping.class);
        if (declaredMapping != null) {
            return declaredMapping.scope();
        }
        return EMPTY_CLASS_ARRAY;
    }

    private Class<?>[] getScopeFromMappingFrom(Class<?> mapTo) {
        MappingScope declaredMappingScope = mapTo.getDeclaredAnnotation(MappingScope.class);
        if (declaredMappingScope != null) {
            return declaredMappingScope.value();
        }
        return EMPTY_CLASS_ARRAY;
    }

    private Class<?>[] getScopeFromDeclaring(Class<?> mapTo) {
        Class<?> declaringClass = mapTo.getDeclaringClass();
        if (declaringClass != null) {
            return this.getScopes(declaringClass, EMPTY_CLASS_ARRAY);
        }
        return EMPTY_CLASS_ARRAY;
    }

    private Class<?>[] getScopeFromSuper(Class<?> mapTo) {
        Class<?> superclass = mapTo.getSuperclass();
        if (superclass != null) {
            return this.getScopes(superclass, EMPTY_CLASS_ARRAY);
        }
        return EMPTY_CLASS_ARRAY;
    }

    private Class<?>[] getViews(Class<?> mapTo) {
        Class[] classArray;
        Mapping mapping = mapTo.getDeclaredAnnotation(Mapping.class);
        MappingView mappingView = mapTo.getDeclaredAnnotation(MappingView.class);
        if (mappingView != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = mappingView.value();
        } else if (mapping != null) {
            classArray = mapping.view();
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = mapTo;
        }
        return classArray;
    }

    private Class<?>[] getFroms(Class<?> mapTo) {
        return Mapper.guessValueInSequence(mapTo, EMPTY_CLASS_ARRAY, this::getFromFromMappingFrom, this::getFromFromMapping, this::getFromFromDeclaring, this::getFromFromSuper);
    }

    private Class<?>[] getFromFromMapping(Class<?> mapTo) {
        Mapping declaredMapping = mapTo.getDeclaredAnnotation(Mapping.class);
        if (declaredMapping != null) {
            return declaredMapping.from();
        }
        return EMPTY_CLASS_ARRAY;
    }

    private Class<?>[] getFromFromMappingFrom(Class<?> mapTo) {
        MappingFrom declaredMappingFrom = mapTo.getDeclaredAnnotation(MappingFrom.class);
        if (declaredMappingFrom != null) {
            return declaredMappingFrom.value();
        }
        return EMPTY_CLASS_ARRAY;
    }

    private Class<?>[] getFromFromDeclaring(Class<?> mapTo) {
        Class<?> declaringClass = mapTo.getDeclaringClass();
        if (declaringClass != null) {
            return this.getFroms(declaringClass);
        }
        return EMPTY_CLASS_ARRAY;
    }

    private Class<?>[] getFromFromSuper(Class<?> mapTo) {
        Class<?> superclass = mapTo.getSuperclass();
        if (superclass != null) {
            return this.getFroms(superclass);
        }
        return EMPTY_CLASS_ARRAY;
    }

    private void configNonDefaultMapping(Class<?> mapFrom, Class<?> mapTo) {
        List<PropertyNonDefaultMapping> propertyNonDefaultMappings = this.collectNonDefaultProperties(mapTo);
        if (!propertyNonDefaultMappings.isEmpty()) {
            propertyNonDefaultMappings.stream().reduce(this.prepareConfigMapping(mapFrom, mapTo), (builder, mapping) -> mapping.configMapping((ClassMapBuilder<?, ?>)builder), Mapper::NotSupportParallelStreamReduce).byDefault(new DefaultFieldMapper[0]).register();
        }
    }

    private List<PropertyNonDefaultMapping> collectNonDefaultProperties(Class<?> mapTo) {
        return BeanClass.create(mapTo).getPropertyWriters().values().stream().map(property -> PropertyNonDefaultMapping.create(this, property)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ClassMapBuilder prepareConfigMapping(Class<?> mapFrom, Class<?> mapTo) {
        this.explicitRegisterSupperClassesWithDefaultMapping(mapFrom, mapTo.getSuperclass());
        return this.mapperFactory.classMap(mapFrom, mapTo);
    }

    private void explicitRegisterSupperClassesWithDefaultMapping(Class<?> mapFrom, Class<?> mapTo) {
        if (Stream.of(this.annotations).anyMatch(a -> mapTo.getAnnotation(a) != null)) {
            if (this.mapperFactory.getClassMap(new MapperKey(TypeFactory.valueOf(mapFrom), TypeFactory.valueOf(mapTo))) == null) {
                this.mapperFactory.classMap(mapFrom, mapTo).byDefault(new DefaultFieldMapper[0]).register();
            }
            this.explicitRegisterSupperClassesWithDefaultMapping(mapFrom, mapTo.getSuperclass());
        }
    }

    public <T> T map(Object source, Class<?> view) {
        if (source == null) {
            return null;
        }
        return this.findMapping(source.getClass(), view).map(t -> this.mapTo(source, (Class)t)).orElse(null);
    }

    public <T> T mapTo(Object source, Class<T> t) {
        return (T)this.mapperFactory.getMapperFacade().map(source, t);
    }

    public Optional<Class<?>> findMapping(Class<?> fromClass, Class<?> view) {
        return this.mappingRegisterData.findMapTo(fromClass, view, this.scope);
    }

    public void setScope(Class<?> scope) {
        this.scope = scope;
    }

    @Deprecated
    public List<Class<?>> findSubMappings(Class<?> mapTo, Class<?> view) {
        return this.mappingRegisterData.findAllSubMapTo(mapTo, view, this.scope);
    }

    public String registerConverter(BaseConverter converter) {
        String converterId = converter.buildConvertId();
        if (this.mapperFactory.getConverterFactory().getConverter(converterId) == null) {
            this.mapperFactory.getConverterFactory().registerConverter(converterId, (Converter)converter);
        }
        return converterId;
    }
}

