/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.map;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MappingRegisterData {
    private Map<Class<?>, Map<Class<?>, Map<Class<?>, Class<?>>>> sourceViewScopeMappingMap = new HashMap();
    private Map<Class<?>, Map<Class<?>, List<Class<?>>>> viewScopeMappingListMap = new HashMap();

    MappingRegisterData() {
    }

    void register(Class<?> mapFrom, Class<?> view, Class<?> scope, Class<?> mapTo) {
        if (!Modifier.isPublic(mapFrom.getModifiers())) {
            throw new IllegalArgumentException(mapFrom.getName() + " should be public");
        }
        Class<?> exist = this.sourceViewScopeMappingMap.computeIfAbsent(mapFrom, f -> new HashMap()).computeIfAbsent(view, f -> new HashMap()).put(scope, mapTo);
        if (exist != null && exist != mapTo) {
            System.err.println(String.format("Warning: %s and %s have the same view and scope in view mapper ", exist.getName(), mapTo.getName()));
        }
        this.viewScopeMappingListMap.computeIfAbsent(view, f1 -> new HashMap()).computeIfAbsent(scope, f2 -> new ArrayList()).add(mapTo);
    }

    Optional<Class<?>> findMapTo(Class<?> fromClass, Class<?> view, Class<?> scope) {
        Map scopeMapping = this.sourceViewScopeMappingMap.getOrDefault(fromClass, Collections.emptyMap()).getOrDefault(view, Collections.emptyMap());
        Class to = (Class)scopeMapping.get(scope);
        return Optional.ofNullable(to != null ? to : (Class)scopeMapping.get(Void.TYPE));
    }

    List<Class<?>> findAllSubMapTo(Class<?> baseMapping, Class<?> view, Class<?> scope) {
        Map scopeDestListMap = this.viewScopeMappingListMap.getOrDefault(view, Collections.emptyMap());
        return Stream.concat(scopeDestListMap.getOrDefault(scope, Collections.emptyList()).stream(), scopeDestListMap.getOrDefault(Void.TYPE, Collections.emptyList()).stream()).filter(baseMapping::isAssignableFrom).collect(Collectors.toList());
    }
}

