/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.map;

import com.github.leeonky.map.Mapper;
import com.github.leeonky.map.Permit;
import com.github.leeonky.map.PermitAction;
import com.github.leeonky.map.PermitRegisterConfig;
import com.github.leeonky.map.PermitScope;
import com.github.leeonky.map.PermitTarget;
import com.github.leeonky.map.PolymorphicPermitIdentity;
import com.github.leeonky.map.PolymorphicPermitIdentityString;
import com.github.leeonky.map.ToProperty;
import com.github.leeonky.map.Transform;
import com.github.leeonky.map.Transformer;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.Classes;
import com.github.leeonky.util.Converter;
import com.github.leeonky.util.ConverterFactory;
import com.github.leeonky.util.PropertyWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.reflections.Reflections;

public class PermitMapper {
    private static final Class<?>[] VOID_SCOPES = new Class[]{Void.TYPE};
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private final Converter converter = ConverterFactory.create();
    private final PermitRegisterConfig permitRegisterConfig = new PermitRegisterConfig();
    private Class<?> scope = Void.TYPE;

    public PermitMapper(String ... packages) {
        HashSet classes = new HashSet();
        Reflections reflections = new Reflections((Object[])packages);
        classes.addAll(reflections.getTypesAnnotatedWith(Permit.class));
        classes.addAll(reflections.getTypesAnnotatedWith(PermitTarget.class));
        classes.addAll(reflections.getTypesAnnotatedWith(PermitAction.class));
        classes.forEach(this::register);
    }

    private Class<?>[] getTargetsFromPermitTarget(Class<?> type) {
        PermitTarget permitTarget = type.getDeclaredAnnotation(PermitTarget.class);
        if (permitTarget != null) {
            return permitTarget.value();
        }
        return EMPTY_CLASS_ARRAY;
    }

    private Class<?>[] getTargetsFromPermit(Class<?> type) {
        Permit permit = type.getDeclaredAnnotation(Permit.class);
        if (permit != null) {
            return permit.target();
        }
        return EMPTY_CLASS_ARRAY;
    }

    private Class<?>[] getTargetsFromDeclaring(Class<?> type) {
        Class<?> declaringClass = type.getDeclaringClass();
        if (declaringClass != null) {
            return this.getTargets(declaringClass);
        }
        return EMPTY_CLASS_ARRAY;
    }

    private void register(Class<?> type) {
        this.permitRegisterConfig.register(this.getActions(type), this.getTargets(type), this.getScopes(type, VOID_SCOPES), this.getParents(type, VOID_SCOPES), type);
        PolymorphicPermitIdentityString identityString = type.getAnnotation(PolymorphicPermitIdentityString.class);
        if (identityString != null) {
            this.permitRegisterConfig.registerPolymorphic(this.getActions(type), this.getScopes(type, VOID_SCOPES), identityString.value(), type);
        }
    }

    private Class<?>[] getParentsFromPermit(Class<?> type) {
        Permit permit = type.getDeclaredAnnotation(Permit.class);
        if (permit != null) {
            return permit.parent();
        }
        return EMPTY_CLASS_ARRAY;
    }

    private Class<?>[] getParents(Class<?> type, Class<?>[] defaultReturn) {
        return Mapper.guessValueInSequence(type, defaultReturn, this::getParentsFromPermit);
    }

    private Class<?>[] getTargets(Class<?> type) {
        return Mapper.guessValueInSequence(type, EMPTY_CLASS_ARRAY, this::getTargetsFromPermitTarget, this::getTargetsFromPermit, this::getTargetsFromDeclaring, this::getTargetsFromSuper);
    }

    private Class<?>[] getTargetsFromSuper(Class<?> type) {
        Class<?> superclass = type.getSuperclass();
        if (superclass != null) {
            return this.getTargets(superclass);
        }
        return EMPTY_CLASS_ARRAY;
    }

    private Class<?>[] getActions(Class<?> type) {
        PermitAction permitAction = type.getDeclaredAnnotation(PermitAction.class);
        if (permitAction != null) {
            return new Class[]{permitAction.value()};
        }
        Permit annotation = type.getAnnotation(Permit.class);
        if (annotation != null) {
            return annotation.action();
        }
        return EMPTY_CLASS_ARRAY;
    }

    private Class<?>[] getScopesFromPermitScope(Class<?> type) {
        PermitScope permitScope = type.getAnnotation(PermitScope.class);
        if (permitScope != null) {
            return permitScope.value();
        }
        return EMPTY_CLASS_ARRAY;
    }

    private Class<?>[] getScopesFromPermit(Class<?> type) {
        Permit permit = type.getAnnotation(Permit.class);
        if (permit != null) {
            return permit.scope();
        }
        return EMPTY_CLASS_ARRAY;
    }

    private Class<?>[] getScopes(Class<?> type, Class<?>[] defaultReturn) {
        return Mapper.guessValueInSequence(type, defaultReturn, this::getScopesFromPermitScope, this::getScopesFromPermit, this::getScopesFromDeclaring, this::getScopesFromSuper);
    }

    private Class<?>[] getScopesFromSuper(Class<?> type) {
        Class<?> superclass = type.getSuperclass();
        if (superclass != null) {
            return this.getScopes(superclass, EMPTY_CLASS_ARRAY);
        }
        return EMPTY_CLASS_ARRAY;
    }

    private Class<?>[] getScopesFromDeclaring(Class<?> type) {
        Class<?> declaringClass = type.getDeclaringClass();
        if (declaringClass != null) {
            return this.getScopes(declaringClass, EMPTY_CLASS_ARRAY);
        }
        return EMPTY_CLASS_ARRAY;
    }

    public <T> T permit(T object, Class<?> target, Class<?> action) {
        return this.permit(object, target, action, Void.TYPE);
    }

    public <T> T permit(T object, Class<?> target, Class<?> action, Class<?> parent) {
        return (T)this.findPermit(target, action, parent).map(p -> {
            if (object instanceof Map) {
                return this.permitMap((Map)object, (Class<?>)p);
            }
            if (object instanceof List) {
                return this.permitList((List)object, (Class<?>)p);
            }
            throw new IllegalArgumentException("Not support type " + object.getClass().getName() + ", only support Map or List<Map>");
        }).orElse(object);
    }

    private List<?> permitList(List<?> list, Class<?> permit) {
        return list.stream().map(m -> this.permitMap((Map)m, permit)).collect(Collectors.toList());
    }

    private Map<String, ?> permitMap(Map<String, ?> map, Class<?> permit) {
        return this.collectPermittedProperties(map, permit).reduce(new LinkedHashMap(), (result, property) -> this.assignToResult((LinkedHashMap<String, Object>)result, (PropertyWriter<?>)property, this.permitPropertyObjectValue((BeanClass<?>)property.getType(), map.get(property.getName()), permit, (PropertyWriter<?>)property)), Mapper::NotSupportParallelStreamReduce);
    }

    private Stream<? extends PropertyWriter<?>> collectPermittedProperties(Map<String, ?> map, Class<?> permit) {
        return BeanClass.create(permit).getPropertyWriters().values().stream().filter(property -> map.containsKey(property.getName()));
    }

    private LinkedHashMap<String, Object> assignToResult(LinkedHashMap<String, Object> result, PropertyWriter<?> property, Object value) {
        ToProperty toProperty = (ToProperty)property.getAnnotation(ToProperty.class);
        if (toProperty != null) {
            String propertyChain = toProperty.value();
            if (propertyChain.contains("{")) {
                String[] chains = propertyChain.replace("}", "").split("\\{", 2);
                List listValue = ((Collection)value).stream().map(o -> this.assignToNestedMap(new LinkedHashMap<String, Object>(), o, chains[1].split("\\."))).collect(Collectors.toList());
                if (chains[0].isEmpty()) {
                    result.put(property.getName(), listValue);
                } else {
                    this.assignToNestedMap(result, listValue, chains[0].split("\\."));
                }
            } else {
                this.assignToNestedMap(result, value, propertyChain.split("\\."));
            }
        } else {
            result.put(property.getName(), value);
        }
        return result;
    }

    private LinkedHashMap<String, Object> assignToNestedMap(LinkedHashMap<String, Object> result, Object value, String[] propertyChain) {
        LinkedHashMap reduce = Arrays.stream(propertyChain, 0, propertyChain.length - 1).reduce(result, (m, p) -> (LinkedHashMap)m.computeIfAbsent(p, k -> new LinkedHashMap()), Mapper::NotSupportParallelStreamReduce);
        reduce.put(propertyChain[propertyChain.length - 1], value);
        return reduce;
    }

    public Optional<Class<?>> findPermit(Class<?> target, Class<?> action, Class<?> parent) {
        return this.permitRegisterConfig.findPermit(target, action, this.scope, parent);
    }

    public void setScope(Class<?> scope) {
        this.scope = scope;
    }

    private Object permitPropertyObjectValue(BeanClass<?> type, Object value, Class<?> containingPermit, PropertyWriter<?> property) {
        Class permit = type.getType();
        if (value instanceof Map) {
            return this.processPolymorphicAndPermitMap((Map)value, permit, containingPermit, property);
        }
        if (value instanceof Iterable) {
            return this.processPolymorphicAndPermitList(type, (Iterable)value, containingPermit, property);
        }
        Transform transform = (Transform)property.getAnnotation(Transform.class);
        if (transform != null) {
            value = ((Transformer)Classes.newInstance(transform.value(), (Object[])new Object[0])).transform(value);
        }
        return this.converter.tryConvert(permit, value);
    }

    private Object processPolymorphicAndPermitList(BeanClass<?> type, Iterable<?> value, Class<?> containingPermit, PropertyWriter<?> property) {
        BeanClass subGenericType = (BeanClass)type.getTypeArguments(0).orElseThrow(() -> new IllegalStateException(String.format("Should specify element type in '%s::%s'", containingPermit.getName(), property.getName())));
        return StreamSupport.stream(value.spliterator(), false).map(e -> this.permitPropertyObjectValue(subGenericType, e, containingPermit, property)).collect(Collectors.toList());
    }

    private Object processPolymorphicAndPermitMap(Map<String, ?> value, Class<?> permit, Class<?> containingPermit, PropertyWriter<?> property) {
        PermitAction action = (PermitAction)property.getAnnotation(PermitAction.class);
        if (action != null) {
            PolymorphicPermitIdentity polymorphicPermitIdentity = permit.getAnnotation(PolymorphicPermitIdentity.class);
            if (polymorphicPermitIdentity == null) {
                throw new IllegalStateException("Should specify property name via @PolymorphicPermitIdentity in '" + permit.getName() + "'");
            }
            return this.permitMap(value, this.permitRegisterConfig.findPolymorphicPermit(permit, action.value(), this.scope, value.get(polymorphicPermitIdentity.value())).orElseThrow(() -> new IllegalStateException(String.format("Cannot find permit for %s[%s] in '%s::%s'", polymorphicPermitIdentity.value(), value.get(polymorphicPermitIdentity.value()), containingPermit.getName(), property.getName()))));
        }
        return this.permitMap(value, permit);
    }
}

