/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class PermitRegisterConfig {
    private Map<Class<?>, Map<Class<?>, Map<Class<?>, Map<Class<?>, Class<?>>>>> targetActionScopePermits = new HashMap();
    private Map<Object, Map<Class<?>, Map<Class<?>, List<Class<?>>>>> typeActionScopePolymorphicPermits = new HashMap();

    PermitRegisterConfig() {
    }

    void registerPolymorphic(Class<?>[] actions, Class<?>[] scopes, String polymorphicIdentityValue, Class<?> permit) {
        for (Class<?> action : actions) {
            Map subScopePermits = this.typeActionScopePolymorphicPermits.computeIfAbsent(polymorphicIdentityValue, t -> new HashMap()).computeIfAbsent(action, a -> new HashMap());
            for (Class<?> scope : scopes) {
                subScopePermits.computeIfAbsent(scope, s -> new ArrayList()).add(permit);
            }
        }
    }

    void register(Class<?>[] actions, Class<?>[] targets, Class<?>[] scopes, Class<?>[] parents, Class<?> permit) {
        for (Class<?> action : actions) {
            for (Class<?> parent : parents) {
                for (Class<?> target : targets) {
                    Map scopePermitMap = this.targetActionScopePermits.computeIfAbsent(parent, k -> new HashMap()).computeIfAbsent(target, k -> new HashMap()).computeIfAbsent(action, k -> new HashMap());
                    for (Class<?> scope : scopes) {
                        Class<?> exist = scopePermitMap.put(scope, permit);
                        if (exist == null || exist == permit) continue;
                        System.err.println(String.format("Warning: %s and %s have the same view and scope in permit mapper ", exist.getName(), permit.getName()));
                    }
                }
            }
        }
    }

    Optional<Class<?>> findPermit(Class<?> target, Class<?> action, Class<?> scope, Class<?> parent) {
        Map scopePermits = this.targetActionScopePermits.getOrDefault(parent, Collections.emptyMap()).getOrDefault(target, Collections.emptyMap()).getOrDefault(action, new HashMap());
        Class permit = (Class)scopePermits.get(scope);
        return Optional.ofNullable(permit != null ? permit : (Class)scopePermits.get(Void.TYPE));
    }

    Optional<Class<?>> findPolymorphicPermit(Class<?> supperPermit, Class<?> action, Class<?> scope, Object polymorphicIdentityValue) {
        Map scopeSubPermits = this.typeActionScopePolymorphicPermits.getOrDefault(polymorphicIdentityValue, Collections.emptyMap()).getOrDefault(action, Collections.emptyMap());
        List polymorphicPermits = (List)scopeSubPermits.get(scope);
        return (polymorphicPermits != null ? polymorphicPermits : scopeSubPermits.getOrDefault(Void.TYPE, Collections.emptyList())).stream().filter(supperPermit::isAssignableFrom).findFirst();
    }
}

