/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.map;

import com.github.leeonky.map.FromProperty;
import com.github.leeonky.map.FromPropertyWrapper;
import com.github.leeonky.map.MapThroughFromProperty;
import com.github.leeonky.map.MapThroughFromPropertyToCollection;
import com.github.leeonky.map.MapThroughFromPropertyToMap;
import com.github.leeonky.map.MapThroughView;
import com.github.leeonky.map.MapThroughViewAndFromPropertyToCollection;
import com.github.leeonky.map.MapThroughViewAndFromPropertyToMap;
import com.github.leeonky.map.Mapper;
import com.github.leeonky.map.MappingView;
import com.github.leeonky.util.PropertyAccessor;
import ma.glasnost.orika.metadata.ClassMapBuilder;

abstract class PropertyNonDefaultMapping {
    protected final PropertyAccessor<?> property;
    final Mapper mapper;

    PropertyNonDefaultMapping(Mapper mapper, PropertyAccessor<?> property) {
        this.mapper = mapper;
        this.property = property;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static PropertyNonDefaultMapping create(Mapper mapper, PropertyAccessor<?> property) {
        MappingView mappingView = (MappingView)property.getAnnotation(MappingView.class);
        FromProperty fromProperty = (FromProperty)property.getAnnotation(FromProperty.class);
        if (mappingView != null) {
            if (fromProperty == null) return new MapThroughView(mapper, property, mappingView);
            FromPropertyWrapper fromPropertyWrapper = new FromPropertyWrapper(fromProperty);
            if (fromPropertyWrapper.isFlatToCollection()) {
                return new MapThroughViewAndFromPropertyToCollection(mapper, property, mappingView, fromPropertyWrapper);
            }
            if (!fromPropertyWrapper.isFlatToMap()) return null;
            return new MapThroughViewAndFromPropertyToMap(mapper, property, mappingView, fromPropertyWrapper);
        }
        if (fromProperty == null) return null;
        FromPropertyWrapper fromPropertyWrapper = new FromPropertyWrapper(fromProperty);
        if (fromPropertyWrapper.isFlatToCollection()) {
            return new MapThroughFromPropertyToCollection(mapper, property, fromPropertyWrapper);
        }
        if (!fromPropertyWrapper.isFlatToMap()) return new MapThroughFromProperty(mapper, property, fromPropertyWrapper);
        return new MapThroughFromPropertyToMap(mapper, property, fromPropertyWrapper);
    }

    public abstract ClassMapBuilder<?, ?> configMapping(ClassMapBuilder<?, ?> var1);
}

