/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.map;

import com.github.leeonky.map.BaseConverter;
import com.github.leeonky.map.Mapper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

class ViewConverter
extends BaseConverter {
    protected final Class<?> view;
    protected final Mapper mapper;

    ViewConverter(Mapper mapper, Class<?> view) {
        this.view = view;
        this.mapper = mapper;
    }

    public Object convert(Object source, Type destinationType, MappingContext mappingContext) {
        Class rawType = destinationType.getRawType();
        if (Iterable.class.isAssignableFrom(rawType)) {
            return this.mapCollection((Iterable)source, ViewConverter.createCollection(rawType), mappingContext);
        }
        if (rawType.isArray()) {
            return this.mapCollection((Iterable)source, new ArrayList(), mappingContext).toArray((Object[])Array.newInstance(rawType.getComponentType(), 0));
        }
        if (Map.class.isAssignableFrom(rawType)) {
            return this.mapMap((Map)source, ViewConverter.createMap(rawType), mappingContext);
        }
        return this.map(source, mappingContext);
    }

    protected Object map(Object source, MappingContext mappingContext) {
        return this.mapper.findMapping(source.getClass(), this.view).map(d -> {
            Object mappedObject = mappingContext.getMappedObject(source, TypeFactory.valueOf((Class)d));
            return mappedObject != null ? mappedObject : this.mapper.mapTo(source, d);
        }).orElse(null);
    }

    private Map mapMap(Map<?, ?> source, Map result, MappingContext mappingContext) {
        source.forEach((k, v) -> result.put(k, this.map(v, mappingContext)));
        return result;
    }

    private Collection mapCollection(Iterable source, Collection result, MappingContext mappingContext) {
        for (Object e : source) {
            result.add(this.map(e, mappingContext));
        }
        return result;
    }

    @Override
    public String buildConvertId() {
        return String.format("ViewConverter:%s[%d]", this.view.getName(), this.mapper.hashCode());
    }
}

