/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.map;

import com.github.leeonky.map.Mapper;
import com.github.leeonky.map.ViewConverter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.metadata.Type;

class ViewListConverter
extends ViewConverter {
    protected final String propertyName;

    ViewListConverter(Mapper mapper, Class<?> view, String propertyName) {
        super(mapper, view);
        this.propertyName = propertyName;
    }

    @Override
    public Object convert(Object source, Type destinationType, MappingContext mappingContext) {
        Iterable collection;
        Class rawType = destinationType.getRawType();
        Iterable iterable = collection = source instanceof Map ? ViewListConverter.wrapperEntry((Map)source) : (Iterable)source;
        if (Iterable.class.isAssignableFrom(rawType)) {
            return this.mapCollection(collection, ViewListConverter.createCollection(rawType), mappingContext);
        }
        if (rawType.isArray()) {
            return this.mapCollection(collection, new ArrayList<Object>(), mappingContext).toArray((Object[])Array.newInstance(rawType.getComponentType(), 0));
        }
        throw new IllegalStateException("Only support map " + this.propertyName + " to list or array, but target type is " + rawType.getName());
    }

    private Collection<Object> mapCollection(Iterable source, Collection<Object> result, MappingContext mappingContext) {
        for (Object e : source) {
            result.add(this.map(ViewListConverter.getPropertyValue(e, this.propertyName), mappingContext));
        }
        return result;
    }

    @Override
    public String buildConvertId() {
        return String.format("ViewListConverter:%s:%s[%d]", this.propertyName, this.view.getName(), this.mapper.hashCode());
    }

    public static class Entry {
        private Object key;
        private Object value;

        public Entry(Map.Entry e) {
            this.key = e.getKey();
            this.value = e.getValue();
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

