/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.map;

import com.github.leeonky.map.Mapper;
import com.github.leeonky.map.ViewListConverter;
import java.util.Map;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.metadata.Type;

class ViewMapConverter
extends ViewListConverter {
    private final String keyPropertyName;

    ViewMapConverter(Mapper mapper, Class<?> view, String keyPropertyName, String propertyName) {
        super(mapper, view, propertyName);
        this.keyPropertyName = keyPropertyName;
    }

    @Override
    public Object convert(Object source, Type destinationType, MappingContext mappingContext) {
        Class rawType = destinationType.getRawType();
        Iterable collection = source instanceof Map ? ViewMapConverter.wrapperEntry((Map)source) : (Iterable)source;
        return this.mapMap(collection, ViewMapConverter.createMap(rawType), mappingContext);
    }

    private Map mapMap(Iterable source, Map result, MappingContext mappingContext) {
        source.forEach(e -> result.put(ViewMapConverter.getPropertyValue(e, this.keyPropertyName), this.map(ViewMapConverter.getPropertyValue(e, this.propertyName), mappingContext)));
        return result;
    }

    @Override
    public String buildConvertId() {
        return String.format("ViewMapConverter:%s:%s:%s[%d]", this.keyPropertyName, this.propertyName, this.view.getName(), this.mapper.hashCode());
    }
}

