/*
 * Decompiled with CFR 0.152.
 */
package com.github.linyuzai.domain.autoconfigure;

import com.github.linyuzai.domain.core.DomainValidator;
import java.util.Objects;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DirectFieldBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.Validator;

public class ApplicationDomainValidator
implements DomainValidator {
    private final Validator validator;

    public void validate(Object target) {
        BindingResult bindingResult = this.createBindingResult(target);
        this.validator.validate(target, (Errors)bindingResult);
        this.onBindingResult(target, bindingResult);
    }

    protected BindingResult createBindingResult(Object target) {
        return new DirectFieldBindingResult(target, target.getClass().getSimpleName());
    }

    protected void onBindingResult(Object target, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            FieldError error = Objects.requireNonNull(bindingResult.getFieldError());
            String s = target.getClass().getName() + "#" + error.getField();
            throw new IllegalArgumentException(s + ", " + error.getDefaultMessage());
        }
    }

    public Validator getValidator() {
        return this.validator;
    }

    public ApplicationDomainValidator(Validator validator) {
        this.validator = validator;
    }
}

