/*
 * Decompiled with CFR 0.152.
 */
package com.github.linyuzai.router.autoconfigure.management;

import com.github.linyuzai.router.autoconfigure.management.RouterConvertor;
import com.github.linyuzai.router.autoconfigure.management.RouterVO;
import com.github.linyuzai.router.core.concept.PathPatternRouter;
import com.github.linyuzai.router.core.concept.Router;
import java.util.UUID;
import org.springframework.util.StringUtils;

public class DefaultRouterConvertor
implements RouterConvertor {
    @Override
    public RouterVO do2vo(Router router) {
        PathPatternRouter ppr = (PathPatternRouter)router;
        RouterVO vo = new RouterVO();
        vo.setId(ppr.getId());
        vo.setServiceId(ppr.getServiceId());
        vo.setPathPattern(ppr.getPathPattern());
        if ("*".equals(ppr.getPort())) {
            vo.setServerAddress(ppr.getHost());
        } else {
            vo.setServerAddress(ppr.getHost() + ":" + ppr.getPort());
        }
        vo.setForced(ppr.isForced());
        vo.setEnabled(ppr.isEnabled());
        return vo;
    }

    @Override
    public Router vo2do(RouterVO vo) {
        PathPatternRouter router = new PathPatternRouter();
        if (StringUtils.hasText((String)vo.getId())) {
            router.setId(vo.getId());
        } else {
            router.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        }
        router.setServiceId(vo.getServiceId());
        router.setPathPattern(vo.getPathPattern());
        if (vo.getServerAddress().contains(":")) {
            String[] serverAddresses = vo.getServerAddress().split(":");
            router.setHost(serverAddresses[0]);
            router.setPort(serverAddresses.length > 1 ? serverAddresses[1] : "*");
        } else if (vo.getServerAddress().contains("\uff1a")) {
            String[] serverAddresses = vo.getServerAddress().split("\uff1a");
            router.setHost(serverAddresses[0]);
            router.setPort(serverAddresses.length > 1 ? serverAddresses[1] : "*");
        } else {
            router.setHost(vo.getServerAddress());
            router.setPort("*");
        }
        router.setForced(vo.getForced().booleanValue());
        router.setEnabled(vo.getEnabled().booleanValue());
        router.setTimestamp(System.currentTimeMillis());
        return router;
    }
}

