/*
 * Decompiled with CFR 0.152.
 */
package com.github.linyuzai.router.autoconfigure.management;

import com.github.linyuzai.router.autoconfigure.management.ResultVO;
import com.github.linyuzai.router.autoconfigure.management.RouterConvertor;
import com.github.linyuzai.router.autoconfigure.management.RouterVO;
import com.github.linyuzai.router.core.concept.RouterConcept;
import com.github.linyuzai.router.core.exception.RouterException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/concept-router/management"})
public class RouterManagementController {
    @Autowired
    private RouterConcept concept;
    @Autowired
    private RouterConvertor convertor;

    @PostMapping(value={"/add"})
    public ResultVO add(@RequestBody RouterVO router) {
        try {
            router.setId(null);
            this.concept.add(this.convertor.vo2do(router));
            return ResultVO.builder().success(true).build();
        }
        catch (Throwable e) {
            return ResultVO.builder().success(false).message(e.getMessage()).build();
        }
    }

    @PutMapping(value={"/update"})
    public ResultVO update(@RequestBody RouterVO router) {
        try {
            if (!StringUtils.hasText((String)router.getId())) {
                throw new RouterException("Id is null");
            }
            this.concept.update(this.convertor.vo2do(router));
            return ResultVO.builder().success(true).build();
        }
        catch (Throwable e) {
            return ResultVO.builder().success(false).message(e.getMessage()).build();
        }
    }

    @DeleteMapping(value={"/delete"})
    public ResultVO delete(@RequestParam String id) {
        try {
            this.concept.delete(id);
            return ResultVO.builder().success(true).build();
        }
        catch (Throwable e) {
            return ResultVO.builder().success(false).message(e.getMessage()).build();
        }
    }

    @GetMapping(value={"/list"})
    public ResultVO list() {
        try {
            List vos = this.concept.routers().stream().map(this.convertor::do2vo).collect(Collectors.toList());
            return ResultVO.builder().success(true).object(vos).build();
        }
        catch (Throwable e) {
            return ResultVO.builder().success(false).message(e.getMessage()).build();
        }
    }
}

