/*
 * Decompiled with CFR 0.152.
 */
package com.github.linyuzai.router.autoconfigure.properties;

import java.io.File;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="concept.router")
public class RouterProperties {
    private boolean enabled = true;
    private RepositoryProperties repository = new RepositoryProperties();
    private ManagementProperties management = new ManagementProperties();

    public boolean isEnabled() {
        return this.enabled;
    }

    public RepositoryProperties getRepository() {
        return this.repository;
    }

    public ManagementProperties getManagement() {
        return this.management;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRepository(RepositoryProperties repository) {
        this.repository = repository;
    }

    public void setManagement(ManagementProperties management) {
        this.management = management;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RouterProperties)) {
            return false;
        }
        RouterProperties other = (RouterProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        RepositoryProperties this$repository = this.getRepository();
        RepositoryProperties other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !((Object)this$repository).equals(other$repository)) {
            return false;
        }
        ManagementProperties this$management = this.getManagement();
        ManagementProperties other$management = other.getManagement();
        return !(this$management == null ? other$management != null : !((Object)this$management).equals(other$management));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RouterProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        RepositoryProperties $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : ((Object)$repository).hashCode());
        ManagementProperties $management = this.getManagement();
        result = result * 59 + ($management == null ? 43 : ((Object)$management).hashCode());
        return result;
    }

    public String toString() {
        return "RouterProperties(enabled=" + this.isEnabled() + ", repository=" + this.getRepository() + ", management=" + this.getManagement() + ")";
    }

    public static class ManagementProperties {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ManagementProperties)) {
                return false;
            }
            ManagementProperties other = (ManagementProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isEnabled() == other.isEnabled();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ManagementProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "RouterProperties.ManagementProperties(enabled=" + this.isEnabled() + ")";
        }
    }

    public static class RepositoryProperties {
        private RepositoryType type = RepositoryType.LOCAL;
        private LocalProperties local = new LocalProperties();

        public RepositoryType getType() {
            return this.type;
        }

        public LocalProperties getLocal() {
            return this.local;
        }

        public void setType(RepositoryType type) {
            this.type = type;
        }

        public void setLocal(LocalProperties local) {
            this.local = local;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RepositoryProperties)) {
                return false;
            }
            RepositoryProperties other = (RepositoryProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RepositoryType this$type = this.getType();
            RepositoryType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            LocalProperties this$local = this.getLocal();
            LocalProperties other$local = other.getLocal();
            return !(this$local == null ? other$local != null : !((Object)this$local).equals(other$local));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RepositoryProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RepositoryType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            LocalProperties $local = this.getLocal();
            result = result * 59 + ($local == null ? 43 : ((Object)$local).hashCode());
            return result;
        }

        public String toString() {
            return "RouterProperties.RepositoryProperties(type=" + (Object)((Object)this.getType()) + ", local=" + this.getLocal() + ")";
        }

        public static class LocalProperties {
            private String path = new File(System.getProperty("user.home"), "concept/router").getAbsolutePath();

            public String getPath() {
                return this.path;
            }

            public void setPath(String path) {
                this.path = path;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LocalProperties)) {
                    return false;
                }
                LocalProperties other = (LocalProperties)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$path = this.getPath();
                String other$path = other.getPath();
                return !(this$path == null ? other$path != null : !this$path.equals(other$path));
            }

            protected boolean canEqual(Object other) {
                return other instanceof LocalProperties;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $path = this.getPath();
                result = result * 59 + ($path == null ? 43 : $path.hashCode());
                return result;
            }

            public String toString() {
                return "RouterProperties.RepositoryProperties.LocalProperties(path=" + this.getPath() + ")";
            }
        }

        public static enum RepositoryType {
            MEMORY,
            LOCAL;

        }
    }
}

