/*
 * Decompiled with CFR 0.152.
 */
package com.github.lkqm.auth;

import com.github.lkqm.auth.AuthProperties;
import com.github.lkqm.auth.core.AuthExpressionRoot;
import com.github.lkqm.auth.core.AuthInfoProvider;
import com.github.lkqm.auth.core.AuthInterceptor;
import com.github.lkqm.auth.core.TinyAuth;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableConfigurationProperties(value={AuthProperties.class})
public class AuthConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    private AuthProperties authProperties;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private AuthInfoProvider authInfoProvider;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.authInterceptor());
    }

    @Bean
    public AuthInterceptor authInterceptor() {
        AuthInterceptor authInterceptor = new AuthInterceptor(this.tinyAuth());
        return authInterceptor;
    }

    @Bean
    @ConditionalOnMissingBean
    public TinyAuth tinyAuth() {
        TinyAuth tinyAuth = new TinyAuth(this.authInfoProvider, this.authProperties, this.authExpressionRoot(), this.applicationContext);
        return tinyAuth;
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthExpressionRoot authExpressionRoot() {
        AuthExpressionRoot expressionRoot = new AuthExpressionRoot(this.authInfoProvider);
        return expressionRoot;
    }
}

