/*
 * Decompiled with CFR 0.152.
 */
package com.github.lkqm.auth.core;

import com.github.lkqm.auth.core.AuthInfo;
import com.github.lkqm.auth.core.AuthInfoProvider;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class AuthExpressionRoot {
    protected AuthInfoProvider authProvider;
    public static final String AUTHEN_EXPRESSION = "authen()";
    public static final String AUTHEN_EXPRESSION_PREFIX = "authen";

    public final boolean anno() {
        return true;
    }

    public final boolean authen() {
        AuthInfo authInfo = this.getAuthInfo();
        return this.isAuthen(authInfo);
    }

    public final boolean hasRole(String ... roles) {
        AuthInfo authInfo = this.getAuthInfo();
        if (!this.isAuthen(authInfo)) {
            return false;
        }
        if (authInfo.isSuperAdmin()) {
            return true;
        }
        List<String> userRoles = authInfo.getRoles();
        if (userRoles != null) {
            return CollectionUtils.containsAny(userRoles, Arrays.asList(roles));
        }
        return false;
    }

    public final boolean hasAllRole(String ... roles) {
        AuthInfo authInfo = this.getAuthInfo();
        if (!this.isAuthen(authInfo)) {
            return false;
        }
        if (authInfo.isSuperAdmin()) {
            return true;
        }
        List<String> userRoles = authInfo.getRoles();
        if (userRoles != null) {
            return userRoles.containsAll(Arrays.asList(roles));
        }
        return false;
    }

    public final boolean hasPermission(String ... permissions) {
        AuthInfo authInfo = this.getAuthInfo();
        if (!this.isAuthen(authInfo)) {
            return false;
        }
        if (authInfo.isSuperAdmin()) {
            return true;
        }
        List<String> userPermissions = authInfo.getPermissions();
        if (userPermissions != null) {
            return CollectionUtils.containsAny(userPermissions, Arrays.asList(permissions));
        }
        return false;
    }

    public final boolean hasAllPermission(String ... permissions) {
        AuthInfo authInfo = this.getAuthInfo();
        if (!this.isAuthen(authInfo)) {
            return false;
        }
        if (authInfo.isSuperAdmin()) {
            return true;
        }
        List<String> userPermissions = authInfo.getPermissions();
        if (userPermissions != null) {
            return userPermissions.containsAll(Arrays.asList(permissions));
        }
        return false;
    }

    private AuthInfo getAuthInfo() {
        return this.authProvider.doGetAuthInfo();
    }

    private boolean isAuthen(AuthInfo authInfo) {
        return authInfo != null && !authInfo.isAuthExpired();
    }

    public AuthInfoProvider getAuthProvider() {
        return this.authProvider;
    }

    public AuthExpressionRoot(AuthInfoProvider authProvider) {
        this.authProvider = authProvider;
    }
}

