/*
 * Decompiled with CFR 0.152.
 */
package com.github.lkqm.auth.core;

import com.github.lkqm.auth.core.PatternPermission;
import java.io.Serializable;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class AuthInfo
implements Serializable {
    private boolean authExpired = false;
    private boolean superAdmin = false;
    private List<String> roles;
    private List<String> permissions;
    private List<PatternPermission> patternPermissions;

    public boolean hasPatternPermission(String pattern, String method) {
        if (!CollectionUtils.isEmpty(this.patternPermissions)) {
            for (PatternPermission patternPermission : this.patternPermissions) {
                if (!patternPermission.match(pattern, method)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAuthExpired() {
        return this.authExpired;
    }

    public boolean isSuperAdmin() {
        return this.superAdmin;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public List<PatternPermission> getPatternPermissions() {
        return this.patternPermissions;
    }

    public void setAuthExpired(boolean authExpired) {
        this.authExpired = authExpired;
    }

    public void setSuperAdmin(boolean superAdmin) {
        this.superAdmin = superAdmin;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public void setPatternPermissions(List<PatternPermission> patternPermissions) {
        this.patternPermissions = patternPermissions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthInfo)) {
            return false;
        }
        AuthInfo other = (AuthInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAuthExpired() != other.isAuthExpired()) {
            return false;
        }
        if (this.isSuperAdmin() != other.isSuperAdmin()) {
            return false;
        }
        List<String> this$roles = this.getRoles();
        List<String> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        List<String> this$permissions = this.getPermissions();
        List<String> other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
            return false;
        }
        List<PatternPermission> this$patternPermissions = this.getPatternPermissions();
        List<PatternPermission> other$patternPermissions = other.getPatternPermissions();
        return !(this$patternPermissions == null ? other$patternPermissions != null : !((Object)this$patternPermissions).equals(other$patternPermissions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAuthExpired() ? 79 : 97);
        result = result * 59 + (this.isSuperAdmin() ? 79 : 97);
        List<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        List<String> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        List<PatternPermission> $patternPermissions = this.getPatternPermissions();
        result = result * 59 + ($patternPermissions == null ? 43 : ((Object)$patternPermissions).hashCode());
        return result;
    }

    public String toString() {
        return "AuthInfo(authExpired=" + this.isAuthExpired() + ", superAdmin=" + this.isSuperAdmin() + ", roles=" + this.getRoles() + ", permissions=" + this.getPermissions() + ", patternPermissions=" + this.getPatternPermissions() + ")";
    }
}

