/*
 * Decompiled with CFR 0.152.
 */
package com.github.lkqm.auth.core;

import com.github.lkqm.auth.core.TinyAuth;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AuthInterceptor
extends HandlerInterceptorAdapter {
    private TinyAuth tinyAuth;
    private static String[] excludeControllers = new String[]{"org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController", "org.springframework.boot.autoconfigure.web.BasicErrorController"};

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (handler instanceof HandlerMethod) {
            boolean isNeedTinyAuth;
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            String method = request.getMethod();
            boolean bl = isNeedTinyAuth = !this.isExcludeMethod(method) && !this.isExcludeController(handlerMethod);
            if (isNeedTinyAuth) {
                this.tinyAuth.auth(request, handlerMethod);
            }
        }
        return true;
    }

    private boolean isExcludeController(HandlerMethod handlerMethod) {
        String className = handlerMethod.getBeanType().getName();
        for (String exclude : excludeControllers) {
            if (!exclude.equals(className)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcludeMethod(String method) {
        return method.equalsIgnoreCase("OPTIONS");
    }

    public AuthInterceptor(TinyAuth tinyAuth) {
        this.tinyAuth = tinyAuth;
    }
}

