/*
 * Decompiled with CFR 0.152.
 */
package com.github.lkqm.auth.core;

import java.io.Serializable;
import java.util.Objects;
import org.springframework.util.StringUtils;

public class PatternPermission
implements Serializable {
    private String pattern;
    private String method;

    public PatternPermission(String pattern) {
        this.pattern = pattern;
    }

    public PatternPermission(String pattern, String method) {
        this.pattern = pattern;
        this.method = method == null ? null : method.toUpperCase();
    }

    public boolean match(String pattern, String requestMethod) {
        boolean isUriMatch = Objects.equals(this.pattern, pattern);
        return isUriMatch && (StringUtils.isEmpty((Object)this.method) || this.method.indexOf(requestMethod.toUpperCase()) != -1);
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getMethod() {
        return this.method;
    }
}

