/*
 * Decompiled with CFR 0.152.
 */
package com.github.lkqm.auth.core;

import com.github.lkqm.auth.AuthProperties;
import com.github.lkqm.auth.annotation.Auth;
import com.github.lkqm.auth.core.AuthExpressionRoot;
import com.github.lkqm.auth.core.AuthInfo;
import com.github.lkqm.auth.core.AuthInfoProvider;
import com.github.lkqm.auth.core.ExpressionCheckUtils;
import com.github.lkqm.auth.exception.AuthException;
import com.github.lkqm.auth.exception.AuthExpiredException;
import com.github.lkqm.auth.exception.AuthNotLoggedException;
import com.github.lkqm.auth.exception.AuthPermissionException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class TinyAuth {
    private AuthInfoProvider authInfoProvider;
    private AuthProperties authProperties;
    private AuthExpressionRoot expressionRoot;
    private ApplicationContext applicationContext;
    private static final AntPathMatcher pathMatcher = new AntPathMatcher("/");

    public void auth(HttpServletRequest request, HandlerMethod handlerMethod) throws AuthException {
        Auth auth = this.getAuthAnnotation(handlerMethod);
        if (auth == null) {
            this.checkPatterns(request, handlerMethod);
        } else {
            this.checkAnnotation(auth);
        }
    }

    private Auth getAuthAnnotation(HandlerMethod handlerMethod) {
        Method method = handlerMethod.getMethod();
        Auth auth = (Auth)AnnotationUtils.getAnnotation((Method)method, Auth.class);
        if (auth == null) {
            Class clazz = handlerMethod.getBeanType();
            auth = (Auth)AnnotationUtils.getAnnotation((AnnotatedElement)clazz, Auth.class);
        }
        return auth;
    }

    private void checkAnnotation(Auth auth) {
        boolean isPassed;
        String expression;
        String string = expression = auth.value() == null ? "" : auth.value().trim();
        if (StringUtils.isEmpty((Object)expression)) {
            expression = "authen()";
        }
        if (!(isPassed = ExpressionCheckUtils.check((EvaluationContext)new StandardEvaluationContext((Object)this.expressionRoot), expression))) {
            if (expression.startsWith("authen")) {
                throw new AuthNotLoggedException("\u672a\u767b\u5f55");
            }
            throw new AuthPermissionException("\u65e0\u8bbf\u95ee\u6743\u9650");
        }
    }

    private void checkPatterns(HttpServletRequest request, HandlerMethod handlerMethod) {
        String method = request.getMethod();
        String path = request.getRequestURI().substring(request.getContextPath().length());
        if (this.isAnonPatterns(path)) {
            return;
        }
        AuthInfo authInfo = this.authInfoProvider.doGetAuthInfo();
        if (this.isAuthenPatterns(path)) {
            if (authInfo == null) {
                throw new AuthNotLoggedException("\u672a\u767b\u5f55");
            }
            if (authInfo.isAuthExpired()) {
                throw new AuthExpiredException("\u767b\u5f55\u8fc7\u671f");
            }
            return;
        }
        if (authInfo != null && authInfo.isSuperAdmin()) {
            return;
        }
        if (this.isAuthorPatterns(path)) {
            if (authInfo == null) {
                throw new AuthNotLoggedException("\u672a\u767b\u5f55");
            }
            if (authInfo.isAuthExpired()) {
                throw new AuthExpiredException("\u767b\u5f55\u8fc7\u671f");
            }
            String pattern = this.getHandlerMethodPattern(handlerMethod, path);
            boolean result = authInfo.hasPatternPermission(pattern, method);
            if (!result) {
                throw new AuthPermissionException("\u65e0\u6743\u9650");
            }
        }
    }

    private boolean isAnonPatterns(String path) {
        return this.doMatchPattern(this.authProperties.getAnnoPatterns(), path);
    }

    private boolean isAuthenPatterns(String path) {
        return this.doMatchPattern(this.authProperties.getAuthenPatterns(), path);
    }

    private boolean isAuthorPatterns(String path) {
        return this.doMatchPattern(this.authProperties.getAuthorPatterns(), path);
    }

    private boolean doMatchPattern(List<String> patterns, String path) {
        if (!CollectionUtils.isEmpty(patterns)) {
            for (String pattern : patterns) {
                if (!pathMatcher.match(pattern, path)) continue;
                return true;
            }
        }
        return false;
    }

    private String getHandlerMethodPattern(HandlerMethod handler, String path) {
        RequestMappingInfo requestMappingInfo = null;
        RequestMappingHandlerMapping handlerMapping = (RequestMappingHandlerMapping)this.applicationContext.getBean(RequestMappingHandlerMapping.class);
        Set entries = handlerMapping.getHandlerMethods().entrySet();
        for (Map.Entry entry : entries) {
            RequestMappingInfo oneMappingInfo = (RequestMappingInfo)entry.getKey();
            HandlerMethod oneHandlerMethod = (HandlerMethod)entry.getValue();
            if (!oneHandlerMethod.getMethod().equals(handler.getMethod())) continue;
            requestMappingInfo = oneMappingInfo;
            break;
        }
        if (requestMappingInfo == null) {
            throw new IllegalStateException("Assert requestMappingInfo != null for handler: " + handler);
        }
        Set patterns = requestMappingInfo.getPatternsCondition().getPatterns();
        if (CollectionUtils.isEmpty((Collection)patterns)) {
            throw new IllegalStateException("Assert (patterns != null && patterns.size() != 0) for handler: " + handler);
        }
        if (patterns.size() == 1) {
            return (String)patterns.iterator().next();
        }
        String pattern = null;
        for (String next : patterns) {
            if (!pathMatcher.match(next, path)) continue;
            pattern = next;
            break;
        }
        if (pattern == null) {
            throw new IllegalStateException("Assert (pattern != null) for handler: " + handler);
        }
        return pattern;
    }

    public TinyAuth(AuthInfoProvider authInfoProvider, AuthProperties authProperties, AuthExpressionRoot expressionRoot, ApplicationContext applicationContext) {
        this.authInfoProvider = authInfoProvider;
        this.authProperties = authProperties;
        this.expressionRoot = expressionRoot;
        this.applicationContext = applicationContext;
    }
}

