/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobclient.support;

import com.github.ltsopensource.core.commons.concurrent.limiter.RateLimiter;
import com.github.ltsopensource.core.domain.Job;
import com.github.ltsopensource.core.exception.JobSubmitException;
import com.github.ltsopensource.jobclient.domain.JobClientAppContext;
import com.github.ltsopensource.jobclient.domain.Response;
import com.github.ltsopensource.jobclient.support.JobSubmitExecutor;
import com.github.ltsopensource.jobclient.support.JobSubmitProtectException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class JobSubmitProtector {
    private int maxQPS;
    RateLimiter rateLimiter;
    private int acquireTimeout = 100;
    private String errorMsg;

    public JobSubmitProtector(JobClientAppContext appContext) {
        this.maxQPS = appContext.getConfig().getParameter("job.submit.maxQPS", 500);
        if (this.maxQPS < 10) {
            this.maxQPS = 500;
        }
        this.errorMsg = "the maxQPS is " + this.maxQPS + " , submit too fast , use " + "job.submit.maxQPS" + " can change the concurrent size .";
        this.acquireTimeout = appContext.getConfig().getParameter("job.submit.lock.acquire.timeout", 100);
        this.rateLimiter = RateLimiter.create((double)this.maxQPS);
    }

    public Response execute(List<Job> jobs, JobSubmitExecutor<Response> jobSubmitExecutor) throws JobSubmitException {
        if (!this.rateLimiter.tryAcquire((long)this.acquireTimeout, TimeUnit.MILLISECONDS)) {
            throw new JobSubmitProtectException(this.maxQPS, this.errorMsg);
        }
        return jobSubmitExecutor.execute(jobs);
    }

    public int getMaxQPS() {
        return this.maxQPS;
    }
}

