/*
 * Decompiled with CFR 0.152.
 */
package com.talor.core.config;

import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.google.common.collect.Lists;
import com.talor.core.hanlder.DubboMethodReturnValueHandler;
import com.talor.core.mapping.DubboHandlerMethodMapping;
import com.talor.core.resolver.AnnotationNamedValueMethodArgumentResolver;
import com.talor.core.resolver.DubboMethodArgumentResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewResolverRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.ViewNameMethodReturnValueHandler;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

@Configuration
public class WebMvcSupportConfig
extends WebMvcConfigurerAdapter {
    public static FastJsonHttpMessageConverter fastJsonHttpMessageConverter() {
        FastJsonConfig config = new FastJsonConfig();
        config.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteDateUseDateFormat});
        config.setFeatures(new Feature[]{Feature.DisableSpecialKeyDetect, Feature.SupportAutoType, Feature.OrderedField});
        FastJsonHttpMessageConverter converter = new FastJsonHttpMessageConverter();
        converter.setFastJsonConfig(config);
        converter.setSupportedMediaTypes((List)Lists.newArrayList((Object[])new MediaType[]{MediaType.APPLICATION_JSON}));
        return converter;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        super.addInterceptors(registry);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
        registry.addResourceHandler(new String[]{"/api/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/static/"});
        super.addResourceHandlers(registry);
    }

    public void configureViewResolvers(ViewResolverRegistry registry) {
        registry.viewResolver((ViewResolver)new InternalResourceViewResolver());
        registry.order(1);
        super.configureViewResolvers(registry);
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(new DubboMethodArgumentResolver(Collections.singletonList(WebMvcSupportConfig.fastJsonHttpMessageConverter())));
        argumentResolvers.add((HandlerMethodArgumentResolver)new AnnotationNamedValueMethodArgumentResolver());
        super.addArgumentResolvers(argumentResolvers);
    }

    public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
        returnValueHandlers.add(new DubboMethodReturnValueHandler());
        super.addReturnValueHandlers(returnValueHandlers);
    }

    @Bean
    public DubboHandlerMethodMapping dubboHandlerMethodMapping(RequestMappingHandlerAdapter requestMappingHandlerAdapter) {
        requestMappingHandlerAdapter.setReturnValueHandlers(this.adjustHandlerMethodReturnValueHandlerOrder(requestMappingHandlerAdapter.getReturnValueHandlers()));
        return new DubboHandlerMethodMapping();
    }

    private List<HandlerMethodReturnValueHandler> adjustHandlerMethodReturnValueHandlerOrder(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
        ArrayList handlers = Lists.newArrayList();
        for (HandlerMethodReturnValueHandler returnValueHandler : returnValueHandlers) {
            if (returnValueHandler instanceof ViewNameMethodReturnValueHandler) {
                handlers.add(new DubboMethodReturnValueHandler());
            }
            handlers.add(returnValueHandler);
        }
        return handlers;
    }
}

