/*
 * Decompiled with CFR 0.152.
 */
package com.talor.core.hanlder;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.RequestHandlerKey;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.web.paths.Paths;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;

public class DubboApiRequestHandler
implements RequestHandler {
    private final HandlerMethodResolver methodResolver;
    private final TypeResolver typeResolver;
    private final RequestMappingInfo requestMapping;
    private List<ResolvedMethodParameter> parameters;
    private HandlerMethod handlerMethod;

    public DubboApiRequestHandler(HandlerMethodResolver methodResolver, TypeResolver typeResolver, RequestMappingInfo requestMapping, HandlerMethod handlerMethod) {
        this.methodResolver = methodResolver;
        this.typeResolver = typeResolver;
        this.requestMapping = requestMapping;
        this.handlerMethod = handlerMethod;
    }

    public Class<?> declaringClass() {
        return this.handlerMethod.getBeanType();
    }

    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return null != AnnotationUtils.findAnnotation((Method)this.handlerMethod.getMethod(), annotation);
    }

    public PatternsRequestCondition getPatternsCondition() {
        return this.requestMapping.getPatternsCondition();
    }

    public String groupName() {
        return Paths.splitCamelCase((String)this.declaringClass().getSimpleName(), (String)"-").replace("/", "").toLowerCase();
    }

    public String getName() {
        Method method = this.handlerMethod.getMethod();
        return Stream.of(method.getDeclaringClass().getDeclaredMethods()).filter(m -> m.getName().equals(method.getName())).count() == 1L ? method.getName() : method.getName() + "_(" + Stream.of(method.getParameters()).map(Parameter::getType).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ")";
    }

    public Set<RequestMethod> supportedMethods() {
        return this.requestMapping.getMethodsCondition().getMethods();
    }

    public Set<? extends MediaType> produces() {
        return this.requestMapping.getProducesCondition().getProducibleMediaTypes();
    }

    public Set<? extends MediaType> consumes() {
        return this.requestMapping.getConsumesCondition().getConsumableMediaTypes();
    }

    public Set<NameValueExpression<String>> headers() {
        return Sets.newHashSet();
    }

    public Set<NameValueExpression<String>> params() {
        return Sets.newHashSet();
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        return Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Method)this.handlerMethod.getMethod(), annotation));
    }

    public RequestHandlerKey key() {
        return new RequestHandlerKey(this.getPatternsCondition().getPatterns(), this.supportedMethods(), this.consumes(), this.produces());
    }

    public List<ResolvedMethodParameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = this.methodResolver.methodParameters(this.handlerMethod);
        }
        return this.parameters;
    }

    public ResolvedType getReturnType() {
        return this.typeResolver.resolve(this.handlerMethod.getReturnType().getGenericParameterType(), new Type[0]);
    }

    public <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> annotation) {
        return Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Class)this.handlerMethod.getBeanType(), annotation));
    }

    public RequestMappingInfo getRequestMapping() {
        return this.requestMapping;
    }

    public HandlerMethod getHandlerMethod() {
        return this.handlerMethod;
    }

    public RequestHandler combine(RequestHandler other) {
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DubboApiRequestHandler{");
        sb.append("key=").append(this.key());
        sb.append('}');
        return sb.toString();
    }
}

