/*
 * Decompiled with CFR 0.152.
 */
package com.talor.core.mapping;

import com.alibaba.dubbo.config.annotation.Service;
import io.swagger.annotations.Api;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.dubbo.config.spring.ServiceBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class DubboHandlerMethodMapping<T>
extends AbstractHandlerMethodMapping<RequestMappingInfo> {
    private static final Logger log = LoggerFactory.getLogger(DubboHandlerMethodMapping.class);
    private ApplicationContext applicationContext;

    protected void initApplicationContext(ApplicationContext context) {
        super.initApplicationContext(context);
        this.applicationContext = context;
    }

    protected boolean isHandler(Class<?> beanType) {
        return ServiceBean.class.isAssignableFrom(beanType) || com.alibaba.dubbo.config.spring.ServiceBean.class.isAssignableFrom(beanType) || AnnotatedElementUtils.hasAnnotation(beanType, Service.class) || AnnotatedElementUtils.hasAnnotation(beanType, org.apache.dubbo.config.annotation.Service.class);
    }

    protected void detectHandlerMethods(Object handler) {
        if (handler instanceof String) {
            String beanName = (String)handler;
            handler = this.getApplicationContext().getBean(beanName);
        }
        Class interfaceType = ClassUtils.getUserClass(handler.getClass());
        Map methods = MethodIntrospector.selectMethods((Class)interfaceType, method -> this.getMappingForMethod(method, interfaceType));
        for (Map.Entry entry : methods.entrySet()) {
            Method invocableMethod = AopUtils.selectInvocableMethod((Method)((Method)entry.getKey()), (Class)interfaceType);
            RequestMappingInfo mapping = (RequestMappingInfo)entry.getValue();
            this.registerHandlerMethod(handler, invocableMethod, mapping);
        }
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> interfaceType) {
        if (!Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) && this.support(method, interfaceType)) {
            return this.createRequestMappingInfo(method, interfaceType);
        }
        return null;
    }

    protected Set<String> getMappingPathPatterns(RequestMappingInfo info) {
        return info.getPatternsCondition().getPatterns();
    }

    protected RequestMappingInfo getMatchingMapping(RequestMappingInfo info, HttpServletRequest request) {
        return info.getMatchingCondition(request);
    }

    protected Comparator<RequestMappingInfo> getMappingComparator(HttpServletRequest request) {
        return (info1, info2) -> info1.compareTo(info2, request);
    }

    private RequestMappingInfo createRequestMappingInfo(Method method, Class<?> interfaceType) {
        Class<?> aClass = this.applicationContext.getBean(interfaceType).getClass();
        Annotation[] annotations = aClass.getAnnotations();
        Optional<Annotation> classPathAnnotation = Arrays.stream(annotations).filter(f -> f instanceof Path).findFirst();
        if (!classPathAnnotation.isPresent()) {
            log.warn("class {} doesn't define path annotation", (Object)aClass.getName());
            return null;
        }
        Path classPath = (Path)classPathAnnotation.get();
        Method[] methods = aClass.getDeclaredMethods();
        Optional<Method> methodOptional = Arrays.stream(methods).filter(f -> f.getName().equals(method.getName()) && Arrays.stream(f.getDeclaredAnnotations()).anyMatch(a -> a instanceof Path)).findFirst();
        if (!methodOptional.isPresent()) {
            log.warn("method {} doesn't define path annotation", (Object)method.getName());
            return null;
        }
        Annotation[] declaredAnnotations = methodOptional.get().getDeclaredAnnotations();
        Optional<Annotation> methodPathAnnotation = Arrays.stream(declaredAnnotations).filter(f -> f instanceof Path).findFirst();
        Path methodPath = (Path)methodPathAnnotation.get();
        Annotation[] interfaceAnnotation = this.findInterfaceClass(method, interfaceType);
        Annotation[] distinctAnnotations = this.getDistinctAnnotations(declaredAnnotations, interfaceAnnotation);
        RequestMappingInfo.Builder builder = RequestMappingInfo.paths((String[])new String[]{classPath.value() + "/" + methodPath.value()}).methods(new RequestMethod[]{this.findRequestMethod(distinctAnnotations)}).consumes(this.findMethodConsumes(distinctAnnotations)).produces(this.findMethodProduces(distinctAnnotations));
        return builder.build();
    }

    private Annotation[] findInterfaceClass(Method method, Class<?> cls) {
        Class<?>[] clsInterfaces = cls.getInterfaces();
        Optional<Class> first = ((Stream)Arrays.stream(clsInterfaces).parallel()).filter(f -> {
            try {
                f.getDeclaredMethod(method.getName(), method.getParameterTypes());
                return true;
            }
            catch (NoSuchMethodException e) {
                log.warn("NoSuchMethodException match interface : {},method: {} fail", (Object)f.getTypeName(), (Object)method.getName());
                return false;
            }
        }).findFirst();
        if (first.isPresent()) {
            try {
                return first.get().getDeclaredMethod(method.getName(), method.getParameterTypes()).getDeclaredAnnotations();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Annotation[0];
    }

    private Annotation[] getDistinctAnnotations(Annotation[] a, Annotation[] b) {
        HashSet<Annotation> annotationHashSet = new HashSet<Annotation>();
        annotationHashSet.addAll(Arrays.asList(a));
        annotationHashSet.addAll(Arrays.asList(b));
        return annotationHashSet.toArray(new Annotation[annotationHashSet.size()]);
    }

    private RequestMethod findRequestMethod(Annotation[] declaredAnnotations) {
        boolean anyMatch = Arrays.stream(declaredAnnotations).anyMatch(f -> Arrays.stream(f.annotationType().getAnnotations()).anyMatch(a -> a instanceof HttpMethod));
        if (!anyMatch) {
            return RequestMethod.POST;
        }
        Optional<Annotation> first = Arrays.stream(declaredAnnotations).filter(f -> Arrays.stream(f.annotationType().getAnnotations()).anyMatch(i -> i instanceof HttpMethod)).findFirst();
        if (!first.isPresent()) {
            return RequestMethod.POST;
        }
        String className = first.get().annotationType().getName();
        String name = className.substring(className.lastIndexOf(46) + 1);
        Optional<RequestMethod> requestMethod = Arrays.stream(RequestMethod.values()).filter(f -> f.name().equals(name)).findFirst();
        return requestMethod.orElse(RequestMethod.POST);
    }

    private String[] findMethodConsumes(Annotation[] declaredAnnotations) {
        Optional<Annotation> first = Arrays.stream(declaredAnnotations).filter(f -> f instanceof Consumes).findFirst();
        if (first.isPresent()) {
            return ((Consumes)first.get()).value();
        }
        return new String[]{"application/json"};
    }

    private String[] findMethodProduces(Annotation[] declaredAnnotations) {
        Optional<Annotation> first = Arrays.stream(declaredAnnotations).filter(f -> f instanceof Produces).findFirst();
        if (first.isPresent()) {
            return ((Produces)first.get()).value();
        }
        return new String[]{"application/json"};
    }

    private boolean support(Method method, Class interfaceType) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)interfaceType, Api.class);
    }
}

