/*
 * Decompiled with CFR 0.152.
 */
package com.talor.core.provider;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.collect.Lists;
import com.talor.core.util.TypeUtils;
import io.swagger.annotations.ApiModel;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationModelsProviderPlugin;
import springfox.documentation.spi.service.contexts.RequestMappingContext;

public class ApiMethodModelsProvider
implements OperationModelsProviderPlugin {
    private final TypeResolver typeResolver;

    @Autowired
    public ApiMethodModelsProvider(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public void apply(RequestMappingContext context) {
        this.collectFromReturnType(context);
    }

    private void collectFromReturnType(RequestMappingContext context) {
        ResolvedType modelType = context.alternateFor(context.getReturnType());
        context.operationModelsBuilder().addReturn((Type)modelType);
    }

    private List<ResolvedType> collectAllTypes(RequestMappingContext context, ResolvedMethodParameter parameter) {
        ArrayList allTypes = Lists.newArrayList();
        for (ResolvedType type : this.collectBindingTypes(context.alternateFor(parameter.getParameterType()), Lists.newArrayList())) {
            ApiModel apiModel = (ApiModel)AnnotationUtils.getAnnotation((AnnotatedElement)type.getErasedType(), ApiModel.class);
            allTypes.add(type);
            if (apiModel == null) continue;
            allTypes.addAll(Arrays.stream(apiModel.subTypes()).filter(subType -> subType.getAnnotation(ApiModel.class) != type.getErasedType().getAnnotation(ApiModel.class)).map(x$0 -> this.typeResolver.resolve(x$0, new Type[0])).collect(Collectors.toList()));
        }
        return allTypes;
    }

    private List<ResolvedType> collectBindingTypes(ResolvedType type, List<ResolvedType> types) {
        if (TypeUtils.isComplexObjectType(type.getErasedType())) {
            types.add(type);
        }
        if (TypeUtils.isBaseType(type.getErasedType()) || type.getTypeBindings().isEmpty()) {
            return types;
        }
        for (ResolvedType resolvedType : type.getTypeBindings().getTypeParameters()) {
            this.collectBindingTypes(resolvedType, types);
        }
        return types;
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

