/*
 * Decompiled with CFR 0.152.
 */
package com.talor.core.provider;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.talor.core.hanlder.DubboApiRequestHandler;
import com.talor.core.mapping.DubboHandlerMethodMapping;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;

public class DubboApiRequestHandlerProvider
implements RequestHandlerProvider,
InitializingBean,
ApplicationContextAware {
    private HandlerMethodResolver handlerMethodResolver;
    private TypeResolver typeResolver;
    private List<DubboHandlerMethodMapping> methodMappings = Lists.newArrayList();
    private ApplicationContext applicationContext;

    public DubboApiRequestHandlerProvider(HandlerMethodResolver handlerMethodResolver, TypeResolver typeResolver) {
        this.handlerMethodResolver = handlerMethodResolver;
        this.typeResolver = typeResolver;
    }

    public void afterPropertiesSet() throws Exception {
        this.methodMappings.addAll(this.applicationContext.getBeansOfType(DubboHandlerMethodMapping.class).values());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public List<RequestHandler> requestHandlers() {
        return Orderings.byPatternsCondition().sortedCopy((Iterable)FluentIterable.from((Iterable)BuilderDefaults.nullToEmptyList(this.methodMappings)).transformAndConcat(this.toMappingEntries()).transform(this.toRequestHandler()));
    }

    private Function<? super DubboHandlerMethodMapping, Iterable<Map.Entry<RequestMappingInfo, HandlerMethod>>> toMappingEntries() {
        return input -> input.getHandlerMethods().entrySet();
    }

    private Function<Map.Entry<RequestMappingInfo, HandlerMethod>, RequestHandler> toRequestHandler() {
        return input -> new DubboApiRequestHandler(this.handlerMethodResolver, this.typeResolver, (RequestMappingInfo)input.getKey(), (HandlerMethod)input.getValue());
    }
}

