/*
 * Decompiled with CFR 0.152.
 */
package com.talor.core.reader;

import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ApiListingBuilderPlugin;
import springfox.documentation.spi.service.contexts.ApiListingContext;

public class ApiListingTagReader
implements ApiListingBuilderPlugin {
    public void apply(ApiListingContext apiListingContext) {
        String tags;
        com.google.common.base.Optional controllerClass = apiListingContext.getResourceGroup().getControllerClass();
        if (!controllerClass.isPresent()) {
            return;
        }
        Optional<Api> apiOptional = Optional.ofNullable((Api)AnnotationUtils.getAnnotation((AnnotatedElement)((AnnotatedElement)controllerClass.get()), Api.class));
        if (!apiOptional.isPresent()) {
            return;
        }
        Api api = apiOptional.get();
        if (api.tags().length == 0 || StringUtils.isEmpty((Object)(tags = api.tags()[0]))) {
            tags = apiListingContext.getResourceGroup().getGroupName();
        }
        apiListingContext.apiListingBuilder().tagNames((Set)Sets.newHashSet((Object[])new String[]{tags}));
    }

    public boolean supports(DocumentationType documentationType) {
        return true;
    }
}

