/*
 * Decompiled with CFR 0.152.
 */
package com.talor.core.resolver;

import com.talor.core.resolver.AnnotationNamedValueMethodArgumentResolver;
import com.talor.core.util.TypeUtils;
import io.swagger.annotations.Api;
import java.util.Collections;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;

public class DubboMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final RequestResponseBodyMethodProcessor responseBodyMethodProcessor;
    private final AnnotationNamedValueMethodArgumentResolver annotationResolver;

    public DubboMethodArgumentResolver(List<HttpMessageConverter<?>> converters) {
        this.responseBodyMethodProcessor = new RequestResponseBodyMethodProcessor(converters, Collections.emptyList());
        this.annotationResolver = new AnnotationNamedValueMethodArgumentResolver();
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasMethodAnnotation(Api.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        if (parameter.getMethod().getParameterCount() == 1 && TypeUtils.isComplexObjectType(parameter.getParameterType())) {
            return this.responseBodyMethodProcessor.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        }
        return this.annotationResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
    }
}

