/*
 * Decompiled with CFR 0.152.
 */
package com.luter.heimdall.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.luter.heimdall.cache.caffeine.CaffeineCache;
import com.luter.heimdall.core.authorization.dao.impl.CachedAuthorizationMetaDataDao;
import com.luter.heimdall.core.config.ConfigManager;
import com.luter.heimdall.core.config.property.AuthorityProperty;
import com.luter.heimdall.core.utils.StrUtils;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineAuthorizationMetaDataDao
extends CachedAuthorizationMetaDataDao {
    private static final Logger log = LoggerFactory.getLogger(CaffeineAuthorizationMetaDataDao.class);

    public CaffeineAuthorizationMetaDataDao() {
        AuthorityProperty config = ConfigManager.getConfig().getAuthority();
        Cache caffeineCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofHours(config.getSysExpire())).build();
        CaffeineCache caffeineSimpleCache = new CaffeineCache(caffeineCache);
        this.setSysCache(caffeineSimpleCache);
        String sysKey = config.getSysCachedKey();
        this.setSysCacheKey(StrUtils.isBlank((String)sysKey) ? "heimdal:sysAuthorities" : sysKey);
    }
}

