/*
 * Decompiled with CFR 0.152.
 */
package com.luter.heimdall.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.luter.heimdall.core.cache.SimpleCache;
import com.luter.heimdall.core.exception.CacheException;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineCache<K, V>
implements SimpleCache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(CaffeineCache.class);
    private final Cache<K, V> cache;

    public CaffeineCache(Cache<K, V> cache) {
        this.cache = cache;
        log.debug("\u521d\u59cb\u5316 Caffeine Cache \u5b8c\u6bd5");
    }

    public V get(K key) throws CacheException {
        log.debug("\u83b7\u53d6 Caffeine \u7f13\u5b58\u6570\u636e,key:{}", key);
        return (V)this.cache.getIfPresent(key);
    }

    public V put(K key, V value) throws CacheException {
        log.debug("\u4fdd\u5b58 Caffeine \u7f13\u5b58\u6570\u636e,key:{},value:{}", key, value);
        this.cache.put(key, value);
        return value;
    }

    public V remove(K key) throws CacheException {
        log.debug("\u5220\u9664 Caffeine \u7f13\u5b58\u6570\u636e,key:{}", key);
        V previous = this.get(key);
        this.cache.invalidate(key);
        return previous;
    }

    public void clear() throws CacheException {
        log.debug("\u5168\u90e8\u6e05\u9664 Caffeine \u7f13\u5b58\u6570\u636e");
        this.cache.invalidateAll();
    }

    public int size() {
        log.debug("\u83b7\u53d6 Caffeine \u7f13\u5b58\u6570\u636e\u603b\u6570");
        return this.cache.asMap().size();
    }

    public Set<K> keys() {
        log.debug("\u83b7\u53d6 Caffeine \u7f13\u5b58\u6570\u636e\u6240\u6709 key");
        return this.cache.asMap().keySet();
    }

    public Collection<V> values() {
        log.debug("\u83b7\u53d6\u7f13\u5b58\u6570\u636e\u6240\u6709 value");
        return this.cache.asMap().values();
    }
}

