/*
 * Decompiled with CFR 0.152.
 */
package com.luter.heimdall.cache.caffeine;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.luter.heimdall.cache.caffeine.CaffeineCache;
import com.luter.heimdall.core.cache.SimpleCache;
import com.luter.heimdall.core.exception.ExcessiveAttemptsException;
import com.luter.heimdall.core.manager.limiter.LoginPasswordRetryLimit;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineLoginPasswordRetryLimitImpl
implements LoginPasswordRetryLimit {
    private static final Logger log = LoggerFactory.getLogger(CaffeineLoginPasswordRetryLimitImpl.class);
    private SimpleCache<String, AtomicInteger> retryCache = new CaffeineCache<String, AtomicInteger>(Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(this.lockedDuration)).build());
    private int attemptLimit = 3;
    private boolean limitEnabled = true;
    private String keyPrefix = "heimdall:retryLimit:";
    private long lockedDuration = 120L;

    public void increase(String key) {
        String cacheKey = this.keyPrefix + key;
        log.info("\u5f00\u59cb\u767b\u5f55\u6b21\u6570\u903b\u8f91\uff0c\u7528\u6237:{}", (Object)cacheKey);
        if (this.limitEnabled) {
            AtomicInteger retryCount = (AtomicInteger)this.retryCache.get((Object)cacheKey);
            if (null == retryCount) {
                log.info("\u7528\u6237: {} \u9996\u6b21\u767b\u5f55\uff0c\u521d\u59cb\u5316\u767b\u5f55\u6b21\u6570\u5230\u7f13\u5b58", (Object)cacheKey);
                retryCount = new AtomicInteger(0);
                this.retryCache.put((Object)cacheKey, (Object)retryCount);
            }
            log.info("\u7528\u6237 : {} ,\u91cd\u8bd5\u6b21\u6570: {}", (Object)cacheKey, (Object)retryCount.get());
            if (retryCount.incrementAndGet() > this.attemptLimit) {
                log.warn("\u7528\u6237: {} \u91cd\u8bd5\u6b21\u6570:{} ,\u8d85\u8fc7\u6700\u5927\u6b21\u6570\u9650\u5236:{}\uff0c\u9501\u5b9a\u8d26\u6237", new Object[]{cacheKey, retryCount, this.attemptLimit});
                throw new ExcessiveAttemptsException("\u91cd\u8bd5\u6b21\u6570\u592a\u591a\uff0c\u60a8\u7684\u8d26\u53f7\u88ab\u9501\u5b9a " + Duration.ofSeconds(this.lockedDuration).toMinutes() + "\u5206\u949f.\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            this.retryCache.put((Object)cacheKey, (Object)retryCount);
        } else {
            log.warn("\u672a\u5f00\u542f\u767b\u5f55\u91cd\u8bd5\u6b21\u6570\u9650\u5236\u529f\u80fd");
        }
    }

    public void remove(String key) {
        this.retryCache.remove((Object)key);
    }

    public int count(String key) {
        AtomicInteger retryCount = (AtomicInteger)this.retryCache.get((Object)(this.keyPrefix + key));
        if (null != retryCount) {
            return retryCount.get();
        }
        return 0;
    }

    public int leftCount(String key) {
        return this.getAttemptLimit() - this.count(key);
    }

    public SimpleCache<String, AtomicInteger> getRetryCache() {
        return this.retryCache;
    }

    public void setRetryCache(SimpleCache<String, AtomicInteger> retryCache) {
        this.retryCache = retryCache;
    }

    public int getAttemptLimit() {
        return this.attemptLimit;
    }

    public void setAttemptLimit(int attemptLimit) {
        this.attemptLimit = attemptLimit;
    }

    public boolean isLimitEnabled() {
        return this.limitEnabled;
    }

    public void setLimitEnabled(boolean limitEnabled) {
        this.limitEnabled = limitEnabled;
    }

    public long getLockedDuration() {
        return this.lockedDuration;
    }

    public void setLockedDuration(long lockedDuration) {
        this.lockedDuration = lockedDuration;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }
}

