/*
 * Decompiled with CFR 0.152.
 */
package com.luter.heimdall.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.luter.heimdall.cache.caffeine.CaffeineCache;
import com.luter.heimdall.core.config.Config;
import com.luter.heimdall.core.config.ConfigManager;
import com.luter.heimdall.core.servlet.ServletHolder;
import com.luter.heimdall.core.session.dao.impl.CachedSessionDaoImpl;
import com.luter.heimdall.core.session.generator.SessionIdGenerator;
import com.luter.heimdall.core.session.generator.UUIDSessionIdGeneratorImpl;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineSessionDaoImpl
extends CachedSessionDaoImpl {
    private static final Logger log = LoggerFactory.getLogger(CaffeineSessionDaoImpl.class);

    public CaffeineSessionDaoImpl(ServletHolder servletHolder) {
        Config config = ConfigManager.getConfig();
        Cache sessionCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofSeconds(config.getSession().getGlobalSessionTimeout())).build();
        Cache userAuthCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofHours(config.getAuthority().getUserExpire())).build();
        CaffeineCache simSessionCache = new CaffeineCache(sessionCache);
        CaffeineCache simpleUserAuthCache = new CaffeineCache(userAuthCache);
        this.setSessionCache(simSessionCache);
        this.setUserAuthCache(simpleUserAuthCache);
        this.setServletHolder(servletHolder);
        this.setSessionIdGenerator((SessionIdGenerator)new UUIDSessionIdGeneratorImpl());
    }
}

