/*
 * Decompiled with CFR 0.152.
 */
package com.luues.logs.aspect;

import cn.luues.tool.core.datawrap.R;
import cn.luues.tool.core.util.ClassUtil;
import cn.luues.tool.json.JsonUtils;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.luues.core.secondary.SystemInfo;
import com.luues.logs.annotation.EnableLogRecord;
import com.luues.logs.annotation.LogRecord;
import com.luues.logs.annotation.ProfilesType;
import com.luues.logs.entity.Log;
import com.luues.logs.entity.OperationLog;
import com.luues.logs.entity.OperatorUserInfo;
import com.luues.logs.service.Broker;
import com.luues.logs.service.BrokerServer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class LogRecordAspect<T> {
    private static final Logger log = LoggerFactory.getLogger((String)"c.l.l.a.l");
    private boolean enableLogRecords = false;
    private String nameKey = "void";
    private String functionName = "getOperatorUserInfo";
    private Class<?> operatorClass = null;
    private Method operatorMethod = null;
    private T operator = null;
    private List<Log> logList = new ArrayList<Log>();

    @PostConstruct
    public void init() {
        Set set = ClassUtil.scanPackageByAnnotation(EnableLogRecord.class);
        if (set.size() == 0 || set.size() > 1) {
            log.warn("@EnableLogRecord:{}", (Object)"not enable");
        } else {
            Class aClass = (Class)set.iterator().next();
            EnableLogRecord enableLogRecord = aClass.getAnnotation(EnableLogRecord.class);
            ProfilesType[] profilesTypes = enableLogRecord.profiles();
            String profiles = Arrays.stream(profilesTypes).map(profilesType -> profilesType.name()).collect(Collectors.joining(","));
            log.info("@EnableLogRecord:{}, profiles:{}", (Object)"true", (Object)profiles);
            if (!enableLogRecord.operator().getName().equals(this.nameKey)) {
                this.operatorClass = enableLogRecord.operator();
                try {
                    this.operatorMethod = this.operatorClass.getMethod(this.functionName, new Class[0]);
                    this.operator = this.operatorClass.newInstance();
                }
                catch (NoSuchMethodException e) {
                    log.warn("@EnableLogRecord not set operator, Operator information will be empty by default, If necessary, please implements OperatorUserFactory<OperatorUserInfo>");
                }
                catch (IllegalAccessException | InstantiationException e) {
                    log.warn("@EnableLogRecord {} init fail", (Object)this.operatorClass.getName());
                }
            }
            if (profiles.contains(SystemInfo.getActive().toUpperCase()) || profiles.equals(ProfilesType.ALL.name())) {
                this.enableLogRecords = true;
                new BrokerServer();
            }
        }
    }

    @Pointcut(value="@annotation(com.luues.logs.annotation.LogRecord)")
    public void logsRecord() {
    }

    @Around(value="logsRecord()")
    public Object logsRecord(ProceedingJoinPoint joinPoint) throws Throwable {
        if (!this.enableLogRecords) {
            return joinPoint.proceed();
        }
        Method objMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        LogRecord logRecord = objMethod.getAnnotation(LogRecord.class);
        if (null == logRecord) {
            return joinPoint.proceed();
        }
        LocalDateTime startTime = LocalDateTime.now();
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Object result = null;
        try {
            result = joinPoint.proceed();
        }
        catch (Exception e) {
            result = R.FAIL((String)this.deepestException(e).getMessage());
            throw e;
        }
        finally {
            OperatorUserInfo operatorUserInfo = null;
            if (null != this.operator) {
                try {
                    operatorUserInfo = (OperatorUserInfo)this.operatorMethod.invoke(this.operator, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    log.error("log Operator information Record failed, reason:{}", (Object)e.getMessage());
                }
            }
            LocalDateTime endTime = LocalDateTime.now();
            Log log = new Log(joinPoint, request.getRemoteAddr(), request.getRequestURI(), request.getMethod(), logRecord.title(), logRecord.operationType().name(), startTime, endTime, result, operatorUserInfo);
            this.logList.add(log);
        }
        return result;
    }

    @Scheduled(fixedRate=10000L)
    @Async
    public void buildLogs() {
        List<Log> logs = this.logList;
        for (int i = 0; i < logs.size(); ++i) {
            Log log_ = logs.get(i);
            ProceedingJoinPoint joinPoint = log_.getJoinPoint();
            String title = log_.getTitle();
            LocalDateTime startTime = log_.getStartTime();
            LocalDateTime endTime = log_.getEndTime();
            Object result = log_.getResult();
            Long startMilliSecond = startTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
            Long endMilliSecond = endTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
            Long milliSecond = endMilliSecond - startMilliSecond;
            MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
            Object[] parameterNames = methodSignature.getParameterNames();
            Object[] objects = joinPoint.getArgs();
            ObjectNode objectNode = JsonUtils.createObjectNode();
            for (String string : parameterNames) {
                Object object = objects[ArrayUtils.indexOf((Object[])parameterNames, (Object)string)];
                if (object instanceof HttpServletRequest || object instanceof HttpServletResponse || object instanceof Model || object instanceof MultipartFile) continue;
                try {
                    objectNode.put(string, String.valueOf(object));
                }
                catch (Exception e) {
                    try {
                        objectNode.put(string, JsonUtils.toJson((Object)object));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            OperationLog operationLog = new OperationLog();
            operationLog.setOperationId(log_.getOperatorUserInfo().getOperationId());
            operationLog.setOperationAccount(log_.getOperatorUserInfo().getOperationAccount());
            operationLog.setOperationName(log_.getOperatorUserInfo().getOperationName());
            operationLog.setOperationIp(log_.getOperationIp());
            operationLog.setRequestUrl(log_.getRequestUrl());
            operationLog.setRequestMethod(log_.getRequestMethod());
            operationLog.setOperationDate(startTime);
            operationLog.setOperationMsg(title);
            operationLog.setOperationType(log_.getOperationType());
            operationLog.setRequestClass(joinPoint.getSignature().getDeclaringTypeName() + "." + joinPoint.getSignature().getName());
            operationLog.setCreateDate(LocalDateTime.now());
            try {
                operationLog.setRequestParams(JsonUtils.toJson((Object)objectNode));
            }
            catch (Exception e) {
                operationLog.setRequestParams("ERROR:" + e.getMessage());
            }
            String results = JsonUtils.toJson((Object)result);
            Map map = (Map)JsonUtils.parse((String)results, Map.class);
            operationLog.setRequestCode(null == map ? "void" : (Objects.isNull(map.get("resultCode")) ? (Objects.isNull(map.get("code")) ? "void" : String.valueOf(map.get("code"))) : String.valueOf(map.get("code"))));
            operationLog.setRequestResult(results);
            operationLog.setOperationTime(milliSecond);
            Broker.produce(operationLog);
            this.logList.remove(i);
        }
    }

    protected Throwable deepestException(Throwable e) {
        Throwable tmp = e;
        int breakPoint = 0;
        while (tmp.getCause() != null && !tmp.equals(tmp.getCause())) {
            tmp = tmp.getCause();
            if (++breakPoint <= 1000) continue;
            break;
        }
        return tmp;
    }
}

